/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OContainsAllCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;
    protected OOrBlock rightBlock;

    public OContainsAllCondition(int id) {
        super(id);
    }

    public OContainsAllCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean execute(Object left, Object right) {
        if (left instanceof Collection) {
            if (right instanceof Collection) {
                return ((Collection)((Object)left)).containsAll((Collection)((Object)right));
            }
            if (right instanceof Iterable) {
                right = ((Iterable)((Object)right)).iterator();
            }
            if (right instanceof Iterator) {
                Iterator iterator = right;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (((Collection)((Object)left)).contains(next)) continue;
                    return false;
                }
            }
            return ((Collection)((Object)left)).contains(right);
        }
        if (left instanceof Iterable) {
            left = ((Iterable)((Object)left)).iterator();
        }
        if (left instanceof Iterator) {
            if (!(right instanceof Iterable)) {
                right = Collections.singleton(right);
            }
            right = ((Iterable)((Object)right)).iterator();
            Iterator leftIterator = left;
            Iterator rightIterator = right;
            while (rightIterator.hasNext()) {
                Object leftItem = rightIterator.next();
                boolean found = false;
                while (leftIterator.hasNext()) {
                    Object rightItem = leftIterator.next();
                    if (leftItem == null || !leftItem.equals(rightItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (this.right != null) {
            Object rightValue = this.right.execute(currentRecord, ctx);
            return this.execute(leftValue, rightValue);
        }
        if (!OMultiValue.isMultiValue(leftValue)) {
            return false;
        }
        Iterator<Object> iter = OMultiValue.getMultiValueIterator(leftValue);
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof OIdentifiable) {
                if (this.rightBlock.evaluate((OIdentifiable)item, ctx)) continue;
                return false;
            }
            if (item instanceof OResult) {
                if (this.rightBlock.evaluate((OResult)item, ctx)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (this.right != null) {
            Object rightValue = this.right.execute(currentRecord, ctx);
            return this.execute(leftValue, rightValue);
        }
        if (!OMultiValue.isMultiValue(leftValue)) {
            return false;
        }
        Iterator<Object> iter = OMultiValue.getMultiValueIterator(leftValue);
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof OIdentifiable) {
                if (this.rightBlock.evaluate((OIdentifiable)item, ctx)) continue;
                return false;
            }
            if (item instanceof OResult) {
                if (this.rightBlock.evaluate((OResult)item, ctx)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" CONTAINSALL ");
        if (this.right != null) {
            this.right.toString(params, builder);
        } else if (this.rightBlock != null) {
            builder.append("(");
            this.rightBlock.toString(params, builder);
            builder.append(")");
        }
    }

    public OExpression getLeft() {
        return this.left;
    }

    public void setLeft(OExpression left) {
        this.left = left;
    }

    public OExpression getRight() {
        return this.right;
    }

    public void setRight(OExpression right) {
        this.right = right;
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            return false;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            return false;
        }
        return this.rightBlock == null || this.rightBlock.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightBlock != null && !this.rightBlock.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        if (this.rightBlock != null) {
            result.addAll(this.rightBlock.getExternalCalculationConditions());
        }
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.left.needsAliases(aliases)) {
            return true;
        }
        if (this.right != null && this.right.needsAliases(aliases)) {
            return true;
        }
        return this.rightBlock != null && this.rightBlock.needsAliases(aliases);
    }

    @Override
    public OContainsAllCondition copy() {
        OContainsAllCondition result = new OContainsAllCondition(-1);
        result.left = this.left.copy();
        result.right = this.right == null ? null : this.right.copy();
        result.rightBlock = this.rightBlock == null ? null : this.rightBlock.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.left.extractSubQueries(collector);
        if (this.right != null) {
            this.right.extractSubQueries(collector);
        }
        if (this.rightBlock != null) {
            this.rightBlock.extractSubQueries(collector);
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.left != null && this.left.refersToParent()) {
            return true;
        }
        if (this.right != null && this.right.refersToParent()) {
            return true;
        }
        return this.rightBlock != null && this.rightBlock.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OContainsAllCondition that = (OContainsAllCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        return !(this.rightBlock != null ? !this.rightBlock.equals(that.rightBlock) : that.rightBlock != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.rightBlock != null ? this.rightBlock.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.right == null ? null : this.right.getMatchPatternInvolvedAliases();
        List<String> rightBlockX = this.rightBlock == null ? null : this.rightBlock.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (rightX != null) {
            result.addAll(rightX);
        }
        if (rightBlockX != null) {
            result.addAll(rightBlockX);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public boolean isCacheable() {
        if (this.left != null && !this.left.isCacheable()) {
            return false;
        }
        if (this.right != null && !this.right.isCacheable()) {
            return false;
        }
        return this.rightBlock == null || this.rightBlock.isCacheable();
    }
}

