/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OConsoleStatement
extends OSimpleExecStatement {
    protected OIdentifier logLevel;
    protected OExpression message;

    public OConsoleStatement(int id) {
        super(id);
    }

    public OConsoleStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        String msg = "" + this.message.execute((OIdentifiable)null, ctx);
        if (this.logLevel.getStringValue().equalsIgnoreCase("log")) {
            OLogManager.instance().info((Object)this, "%s", msg);
        } else if (this.logLevel.getStringValue().equalsIgnoreCase("output")) {
            System.out.println((Object)msg);
        } else if (this.logLevel.getStringValue().equalsIgnoreCase("error")) {
            System.err.println((Object)msg);
            OLogManager.instance().error(this, "%s", null, msg);
        } else if (this.logLevel.getStringValue().equalsIgnoreCase("warn")) {
            OLogManager.instance().warn((Object)this, "%s", msg);
        } else if (this.logLevel.getStringValue().equalsIgnoreCase("debug")) {
            OLogManager.instance().debug((Object)this, "%s", msg);
        } else {
            throw new OCommandExecutionException("Unsupported log level: " + this.logLevel);
        }
        item.setProperty("operation", "console");
        item.setProperty("level", this.logLevel.getStringValue());
        item.setProperty("message", msg);
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CONSOLE.");
        this.logLevel.toString(params, builder);
        builder.append(" ");
        this.message.toString(params, builder);
    }

    @Override
    public OConsoleStatement copy() {
        OConsoleStatement result = new OConsoleStatement(-1);
        result.logLevel = this.logLevel == null ? null : this.logLevel.copy();
        result.message = this.message == null ? null : this.message.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OConsoleStatement that = (OConsoleStatement)o;
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public int hashCode() {
        int result = this.logLevel != null ? this.logLevel.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

