/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommitStatement
extends OSimpleExecStatement {
    protected OInteger retry;
    protected List<OStatement> elseStatements;
    protected Boolean elseFail;

    public OCommitStatement(int id) {
        super(id);
    }

    public OCommitStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ctx.getDatabase().commit();
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        item.setProperty("operation", "commit");
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("COMMIT");
        if (this.retry != null) {
            builder.append(" RETRY ");
            this.retry.toString(params, builder);
            if (this.elseFail != null || this.elseStatements != null) {
                builder.append(" ELSE ");
            }
            if (this.elseStatements != null) {
                builder.append("{\n");
                for (OStatement stm : this.elseStatements) {
                    stm.toString(params, builder);
                    builder.append(";\n");
                }
                builder.append("}");
            }
            if (this.elseFail != null) {
                if (this.elseStatements != null) {
                    builder.append(" AND");
                }
                if (this.elseFail.booleanValue()) {
                    builder.append(" FAIL");
                } else {
                    builder.append(" CONTINUE");
                }
            }
        }
    }

    @Override
    public OCommitStatement copy() {
        OCommitStatement result = new OCommitStatement(-1);
        OInteger oInteger = result.retry = this.retry == null ? null : this.retry.copy();
        if (this.elseStatements != null) {
            result.elseStatements = new ArrayList<OStatement>();
            for (OStatement stm : this.elseStatements) {
                result.elseStatements.add(stm.copy());
            }
        }
        if (this.elseFail != null) {
            result.elseFail = this.elseFail;
        }
        return result;
    }

    public OInteger getRetry() {
        return this.retry;
    }

    public List<OStatement> getElseStatements() {
        return this.elseStatements;
    }

    public Boolean getElseFail() {
        return this.elseFail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCommitStatement that = (OCommitStatement)o;
        if (this.retry != null ? !this.retry.equals(that.retry) : that.retry != null) {
            return false;
        }
        if (this.elseStatements != null ? !this.elseStatements.equals(that.elseStatements) : that.elseStatements != null) {
            return false;
        }
        return this.elseFail != null ? this.elseFail.equals(that.elseFail) : that.elseFail == null;
    }

    public int hashCode() {
        int result = this.retry != null ? this.retry.hashCode() : 0;
        result = 31 * result + (this.elseStatements != null ? this.elseStatements.hashCode() : 0);
        result = 31 * result + (this.elseFail != null ? this.elseFail.hashCode() : 0);
        return result;
    }
}

