/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OEdgeToVertexIterable;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSQLFunctionShortestPath
extends OSQLFunctionMathAbstract {
    public static final String NAME = "shortestPath";
    public static final String PARAM_MAX_DEPTH = "maxDepth";
    protected static final float DISTANCE = 1.0f;

    public OSQLFunctionShortestPath() {
        super(NAME, 2, 5);
    }

    @Override
    public List<ORID> execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OElement elem;
        OElement elem2;
        ORecord record = iCurrentRecord != null ? (ORecord)iCurrentRecord.getRecord() : null;
        OShortestPathContext ctx = new OShortestPathContext();
        Object source = iParams[0];
        if (OMultiValue.isMultiValue(source)) {
            if (OMultiValue.getSize(source) > 1) {
                throw new IllegalArgumentException("Only one sourceVertex is allowed");
            }
            if ((source = OMultiValue.getFirstValue(source)) instanceof OResult && ((OResult)source).isElement()) {
                source = ((OResult)source).getElement().get();
            }
        }
        if ((source = OSQLHelper.getValue(source, record, iContext)) instanceof OIdentifiable) {
            elem2 = (OElement)((OIdentifiable)source).getRecord();
            if (elem2 == null || !elem2.isVertex()) {
                throw new IllegalArgumentException("The sourceVertex must be a vertex record");
            }
        } else {
            throw new IllegalArgumentException("The sourceVertex must be a vertex record");
        }
        ctx.sourceVertex = elem2.asVertex().get();
        Object dest = iParams[1];
        if (OMultiValue.isMultiValue(dest)) {
            if (OMultiValue.getSize(dest) > 1) {
                throw new IllegalArgumentException("Only one destinationVertex is allowed");
            }
            if ((dest = OMultiValue.getFirstValue(dest)) instanceof OResult && ((OResult)dest).isElement()) {
                dest = ((OResult)dest).getElement().get();
            }
        }
        if ((dest = OSQLHelper.getValue(dest, record, iContext)) instanceof OIdentifiable) {
            elem = (OElement)((OIdentifiable)dest).getRecord();
            if (elem == null || !elem.isVertex()) {
                throw new IllegalArgumentException("The destinationVertex must be a vertex record");
            }
        } else {
            throw new IllegalArgumentException("The destinationVertex must be a vertex record");
        }
        ctx.destinationVertex = elem.asVertex().get();
        if (ctx.sourceVertex.equals(ctx.destinationVertex)) {
            ArrayList<ORID> result = new ArrayList<ORID>(1);
            result.add(ctx.destinationVertex.getIdentity());
            return result;
        }
        if (iParams.length > 2 && iParams[2] != null) {
            ctx.directionLeft = ODirection.valueOf(iParams[2].toString().toUpperCase(Locale.ENGLISH));
        }
        if (ctx.directionLeft == ODirection.OUT) {
            ctx.directionRight = ODirection.IN;
        } else if (ctx.directionLeft == ODirection.IN) {
            ctx.directionRight = ODirection.OUT;
        }
        ctx.edgeType = null;
        if (iParams.length > 3) {
            ctx.edgeType = iParams[3] == null ? null : "" + iParams[3];
        }
        ctx.edgeTypeParam = new String[]{ctx.edgeType};
        if (iParams.length > 4) {
            this.bindAdditionalParams(iParams[4], ctx);
        }
        ctx.queueLeft.add(ctx.sourceVertex);
        ctx.leftVisited.add(ctx.sourceVertex.getIdentity());
        ctx.queueRight.add(ctx.destinationVertex);
        ctx.rightVisited.add(ctx.destinationVertex.getIdentity());
        for (int depth = 1; !(ctx.maxDepth != null && ctx.maxDepth <= depth || ctx.queueLeft.isEmpty() || ctx.queueRight.isEmpty()); ++depth) {
            List<ORID> neighborIdentity;
            if (Thread.interrupted()) {
                throw new OCommandExecutionException("The shortestPath() function has been interrupted");
            }
            if (!OCommandExecutorAbstract.checkInterruption(iContext)) break;
            if (ctx.queueLeft.size() <= ctx.queueRight.size()) {
                neighborIdentity = this.walkLeft(ctx);
                if (neighborIdentity != null) {
                    return neighborIdentity;
                }
                if (ctx.maxDepth != null && ctx.maxDepth <= ++depth || ctx.queueLeft.isEmpty()) break;
                neighborIdentity = this.walkRight(ctx);
                if (neighborIdentity == null) continue;
                return neighborIdentity;
            }
            neighborIdentity = this.walkRight(ctx);
            if (neighborIdentity != null) {
                return neighborIdentity;
            }
            if (ctx.maxDepth != null && ctx.maxDepth <= ++depth || ctx.queueRight.isEmpty()) break;
            neighborIdentity = this.walkLeft(ctx);
            if (neighborIdentity == null) continue;
            return neighborIdentity;
        }
        return new ArrayList<ORID>();
    }

    private void bindAdditionalParams(Object additionalParams, OShortestPathContext ctx) {
        if (additionalParams == null) {
            return;
        }
        Map<String, Object> mapParams = null;
        if (additionalParams instanceof Map) {
            mapParams = (Map<String, Object>)additionalParams;
        } else if (additionalParams instanceof OIdentifiable) {
            mapParams = ((ODocument)((OIdentifiable)additionalParams).getRecord()).toMap();
        }
        if (mapParams != null) {
            ctx.maxDepth = this.integer(mapParams.get(PARAM_MAX_DEPTH));
            Boolean withEdge = this.toBoolean(mapParams.get("edge"));
            ctx.edge = Boolean.TRUE.equals(withEdge) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private Integer integer(Object fromObject) {
        if (fromObject == null) {
            return null;
        }
        if (fromObject instanceof Number) {
            return ((Number)fromObject).intValue();
        }
        if (fromObject instanceof String) {
            try {
                return Integer.parseInt(fromObject.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Boolean toBoolean(Object fromObject) {
        if (fromObject == null) {
            return null;
        }
        if (fromObject instanceof Boolean) {
            return (Boolean)fromObject;
        }
        if (fromObject instanceof String) {
            try {
                return Boolean.parseBoolean(fromObject.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private ORawPair<Iterable<OVertex>, Iterable<OEdge>> getVerticesAndEdges(OVertex srcVertex, ODirection direction, String ... types) {
        if (direction == ODirection.BOTH) {
            OMultiCollectionIterator vertexIterator = new OMultiCollectionIterator();
            OMultiCollectionIterator edgeIterator = new OMultiCollectionIterator();
            ORawPair<Iterable<OVertex>, Iterable<OEdge>> pair1 = this.getVerticesAndEdges(srcVertex, ODirection.OUT, types);
            ORawPair<Iterable<OVertex>, Iterable<OEdge>> pair2 = this.getVerticesAndEdges(srcVertex, ODirection.IN, types);
            vertexIterator.add(pair1.getFirst());
            vertexIterator.add(pair2.getFirst());
            edgeIterator.add(pair1.getSecond());
            edgeIterator.add(pair2.getSecond());
            return new ORawPair<Iterable<OVertex>, Iterable<OEdge>>(vertexIterator, edgeIterator);
        }
        Iterable<OEdge> edges1 = srcVertex.getEdges(direction, types);
        Iterable<OEdge> edges2 = srcVertex.getEdges(direction, types);
        return new ORawPair<Iterable<OVertex>, Iterable<OEdge>>(new OEdgeToVertexIterable(edges1, direction), edges2);
    }

    private ORawPair<Iterable<OVertex>, Iterable<OEdge>> getVerticesAndEdges(OVertex srcVertex, ODirection direction) {
        return this.getVerticesAndEdges(srcVertex, direction, null);
    }

    @Override
    public String getSyntax() {
        return "shortestPath(<sourceVertex>, <destinationVertex>, [<direction>, [ <edgeTypeAsString> ]])";
    }

    protected List<ORID> walkLeft(OShortestPathContext ctx) {
        ArrayDeque<OVertex> nextLevelQueue = new ArrayDeque<OVertex>();
        if (!Boolean.TRUE.equals(ctx.edge)) {
            while (!ctx.queueLeft.isEmpty()) {
                ctx.current = ctx.queueLeft.poll();
                Iterable<OVertex> neighbors = ctx.edgeType == null ? ctx.current.getVertices(ctx.directionLeft) : ctx.current.getVertices(ctx.directionLeft, ctx.edgeTypeParam);
                for (OVertex neighbor : neighbors) {
                    OVertex v = neighbor;
                    ORID neighborIdentity = v.getIdentity();
                    if (ctx.rightVisited.contains(neighborIdentity)) {
                        ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                        return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                    }
                    if (ctx.leftVisited.contains(neighborIdentity)) continue;
                    ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                    nextLevelQueue.offer(v);
                    ctx.leftVisited.add(neighborIdentity);
                }
            }
        } else {
            while (!ctx.queueLeft.isEmpty()) {
                ctx.current = ctx.queueLeft.poll();
                ORawPair<Iterable<OVertex>, Iterable<OEdge>> neighbors = ctx.edgeType == null ? this.getVerticesAndEdges(ctx.current, ctx.directionLeft) : this.getVerticesAndEdges(ctx.current, ctx.directionLeft, ctx.edgeTypeParam);
                Iterator<OVertex> vertexIterator = neighbors.getFirst().iterator();
                Iterator<OEdge> edgeIterator = neighbors.getSecond().iterator();
                while (vertexIterator.hasNext() && edgeIterator.hasNext()) {
                    OVertex v = vertexIterator.next();
                    ORID neighborVertexIdentity = v.getIdentity();
                    ORID neighborEdgeIdentity = edgeIterator.next().getIdentity();
                    if (ctx.rightVisited.contains(neighborVertexIdentity)) {
                        ctx.previouses.put(neighborVertexIdentity, neighborEdgeIdentity);
                        ctx.previouses.put(neighborEdgeIdentity, ctx.current.getIdentity());
                        return this.computePath(ctx.previouses, ctx.nexts, neighborVertexIdentity);
                    }
                    if (ctx.leftVisited.contains(neighborVertexIdentity)) continue;
                    ctx.previouses.put(neighborVertexIdentity, neighborEdgeIdentity);
                    ctx.previouses.put(neighborEdgeIdentity, ctx.current.getIdentity());
                    nextLevelQueue.offer(v);
                    ctx.leftVisited.add(neighborVertexIdentity);
                }
            }
        }
        ctx.queueLeft = nextLevelQueue;
        return null;
    }

    protected List<ORID> walkRight(OShortestPathContext ctx) {
        ArrayDeque<OVertex> nextLevelQueue = new ArrayDeque<OVertex>();
        if (!Boolean.TRUE.equals(ctx.edge)) {
            while (!ctx.queueRight.isEmpty()) {
                ctx.currentRight = ctx.queueRight.poll();
                Iterable<OVertex> neighbors = ctx.edgeType == null ? ctx.currentRight.getVertices(ctx.directionRight) : ctx.currentRight.getVertices(ctx.directionRight, ctx.edgeTypeParam);
                for (OVertex neighbor : neighbors) {
                    OVertex v = neighbor;
                    ORID neighborIdentity = v.getIdentity();
                    if (ctx.leftVisited.contains(neighborIdentity)) {
                        ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                        return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                    }
                    if (ctx.rightVisited.contains(neighborIdentity)) continue;
                    ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                    nextLevelQueue.offer(v);
                    ctx.rightVisited.add(neighborIdentity);
                }
            }
        } else {
            while (!ctx.queueRight.isEmpty()) {
                ctx.currentRight = ctx.queueRight.poll();
                ORawPair<Iterable<OVertex>, Iterable<OEdge>> neighbors = ctx.edgeType == null ? this.getVerticesAndEdges(ctx.currentRight, ctx.directionRight) : this.getVerticesAndEdges(ctx.currentRight, ctx.directionRight, ctx.edgeTypeParam);
                Iterator<OVertex> vertexIterator = neighbors.getFirst().iterator();
                Iterator<OEdge> edgeIterator = neighbors.getSecond().iterator();
                while (vertexIterator.hasNext() && edgeIterator.hasNext()) {
                    OVertex v = vertexIterator.next();
                    ORID neighborVertexIdentity = v.getIdentity();
                    ORID neighborEdgeIdentity = edgeIterator.next().getIdentity();
                    if (ctx.leftVisited.contains(neighborVertexIdentity)) {
                        ctx.nexts.put(neighborVertexIdentity, neighborEdgeIdentity);
                        ctx.nexts.put(neighborEdgeIdentity, ctx.currentRight.getIdentity());
                        return this.computePath(ctx.previouses, ctx.nexts, neighborVertexIdentity);
                    }
                    if (ctx.rightVisited.contains(neighborVertexIdentity)) continue;
                    ctx.nexts.put(neighborVertexIdentity, neighborEdgeIdentity);
                    ctx.nexts.put(neighborEdgeIdentity, ctx.currentRight.getIdentity());
                    nextLevelQueue.offer(v);
                    ctx.rightVisited.add(neighborVertexIdentity);
                }
            }
        }
        ctx.queueRight = nextLevelQueue;
        return null;
    }

    private List<ORID> computePath(Map<ORID, ORID> leftDistances, Map<ORID, ORID> rightDistances, ORID neighbor) {
        ArrayList<ORID> result = new ArrayList<ORID>();
        ORID current = neighbor;
        while (current != null) {
            result.add(0, current);
            current = leftDistances.get(current);
        }
        current = neighbor;
        while (current != null) {
            if ((current = rightDistances.get(current)) == null) continue;
            result.add(current);
        }
        return result;
    }

    private class OShortestPathContext {
        OVertex sourceVertex;
        OVertex destinationVertex;
        ODirection directionLeft = ODirection.BOTH;
        ODirection directionRight = ODirection.BOTH;
        String edgeType;
        String[] edgeTypeParam;
        ArrayDeque<OVertex> queueLeft = new ArrayDeque();
        ArrayDeque<OVertex> queueRight = new ArrayDeque();
        final Set<ORID> leftVisited = new HashSet<ORID>();
        final Set<ORID> rightVisited = new HashSet<ORID>();
        final Map<ORID, ORID> previouses = new HashMap<ORID, ORID>();
        final Map<ORID, ORID> nexts = new HashMap<ORID, ORID>();
        OVertex current;
        OVertex currentRight;
        public Integer maxDepth;
        public Boolean edge;

        private OShortestPathContext() {
        }
    }
}

