/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EmptyStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import java.util.Iterator;
import java.util.List;

public class RetryStep
extends AbstractExecutionStep {
    public List<OStatement> body;
    public List<OStatement> elseBody;
    public boolean elseFail;
    private final int retries;
    Iterator iterator;
    private OExecutionStepInternal finalResult = null;

    public RetryStep(List<OStatement> statements, int retries, List<OStatement> elseStatements, Boolean elseFail, OCommandContext ctx, boolean enableProfiling) {
        super(ctx, enableProfiling);
        this.body = statements;
        this.retries = retries;
        this.elseBody = elseStatements;
        this.elseFail = !Boolean.FALSE.equals(elseFail);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        if (this.finalResult != null) {
            return this.finalResult.syncPull(ctx, nRecords);
        }
        for (int i = 0; i < this.retries; ++i) {
            try {
                if (OExecutionThreadLocal.isInterruptCurrentOperation()) {
                    throw new OCommandInterruptedException("The command has been interrupted");
                }
                OScriptExecutionPlan plan = this.initPlan(this.body, ctx);
                OExecutionStepInternal result2 = plan.executeFull();
                if (result2 != null) {
                    this.finalResult = result2;
                    return result2.syncPull(ctx, nRecords);
                }
                break;
            }
            catch (ONeedRetryException ex) {
                OScriptExecutionPlan plan;
                OExecutionStepInternal result;
                try {
                    ctx.getDatabase().rollback();
                }
                catch (Exception result2) {
                    // empty catch block
                }
                if (i != this.retries - 1) continue;
                if (this.elseBody != null && this.elseBody.size() > 0 && (result = (plan = this.initPlan(this.elseBody, ctx)).executeFull()) != null) {
                    this.finalResult = result;
                    return result.syncPull(ctx, nRecords);
                }
                if (this.elseFail) {
                    throw ex;
                }
                return new OInternalResultSet();
            }
        }
        this.finalResult = new EmptyStep(ctx, false);
        return this.finalResult.syncPull(ctx, nRecords);
    }

    public OScriptExecutionPlan initPlan(List<OStatement> body, OCommandContext ctx) {
        OBasicCommandContext subCtx1 = new OBasicCommandContext();
        subCtx1.setParent(ctx);
        OScriptExecutionPlan plan = new OScriptExecutionPlan(subCtx1);
        for (OStatement stm : body) {
            plan.chain(stm.createExecutionPlan(subCtx1, this.profilingEnabled), this.profilingEnabled);
        }
        return plan;
    }
}

