/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OSelectExecutionPlan
implements OInternalExecutionPlan {
    private String location;
    private OCommandContext ctx;
    protected List<OExecutionStepInternal> steps = new ArrayList<OExecutionStepInternal>();
    OExecutionStepInternal lastStep = null;
    private String statement;

    public OSelectExecutionPlan(OCommandContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void close() {
        this.lastStep.close();
    }

    @Override
    public OResultSet fetchNext(int n) {
        return this.lastStep.syncPull(this.ctx, n);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.steps.size(); ++i) {
            OExecutionStepInternal step = this.steps.get(i);
            result.append(step.prettyPrint(depth, indent));
            if (i >= this.steps.size() - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public void reset(OCommandContext ctx) {
        this.steps.forEach(OExecutionStepInternal::reset);
    }

    public void chain(OExecutionStepInternal nextStep) {
        if (this.lastStep != null) {
            this.lastStep.setNext(nextStep);
            nextStep.setPrevious(this.lastStep);
        }
        this.lastStep = nextStep;
        this.steps.add(nextStep);
    }

    @Override
    public List<OExecutionStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<OExecutionStepInternal> steps) {
        this.steps = steps;
        this.lastStep = steps.size() > 0 ? steps.get(steps.size() - 1) : null;
    }

    @Override
    public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "QueryExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        result.setProperty("steps", this.steps == null ? null : this.steps.stream().map(x -> x.toResult()).collect(Collectors.toList()));
        return result;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "QueryExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        result.setProperty("steps", this.steps == null ? null : this.steps.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        return result;
    }

    @Override
    public void deserialize(OResult serializedExecutionPlan) {
        List serializedSteps = (List)serializedExecutionPlan.getProperty("steps");
        for (OResult serializedStep : serializedSteps) {
            try {
                String className = (String)serializedStep.getProperty("javaType");
                OExecutionStepInternal step = (OExecutionStepInternal)Class.forName(className).newInstance();
                step.deserialize(serializedStep);
                this.chain(step);
            }
            catch (Exception e) {
                throw OException.wrapException(new OCommandExecutionException("Cannot deserialize execution step:" + serializedStep), e);
            }
        }
    }

    @Override
    public OInternalExecutionPlan copy(OCommandContext ctx) {
        OSelectExecutionPlan copy = new OSelectExecutionPlan(ctx);
        this.copyOn(copy, ctx);
        return copy;
    }

    protected void copyOn(OSelectExecutionPlan copy, OCommandContext ctx) {
        OExecutionStepInternal lastStep = null;
        for (OExecutionStep oExecutionStep : this.steps) {
            OExecutionStepInternal newStep = (OExecutionStepInternal)((OExecutionStepInternal)oExecutionStep).copy(ctx);
            newStep.setPrevious(lastStep);
            if (lastStep != null) {
                ((OExecutionStepInternal)lastStep).setNext(newStep);
            }
            lastStep = newStep;
            copy.getSteps().add(newStep);
        }
        copy.lastStep = copy.steps.size() == 0 ? null : copy.steps.get(copy.steps.size() - 1);
        copy.location = this.location;
        copy.statement = this.statement;
    }

    @Override
    public boolean canBeCached() {
        for (OExecutionStepInternal step : this.steps) {
            if (step.canBeCached()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    @Override
    public void setStatement(String statement) {
        this.statement = statement;
    }
}

