/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.FetchFromRidsStep;
import com.orientechnologies.orient.core.sql.executor.FindReferencesStep;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OFindReferencesStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OFindReferencesExecutionPlanner {
    protected ORid rid;
    protected OStatement subQuery;
    protected List<SimpleNode> targets;

    public OFindReferencesExecutionPlanner(OFindReferencesStatement statement) {
        this.rid = statement.getRid() == null ? null : statement.getRid().copy();
        this.subQuery = statement.getSubQuery() == null ? null : statement.getSubQuery().copy();
        this.targets = statement.getTargets() == null ? null : statement.getTargets().stream().map(x -> x.copy()).collect(Collectors.toList());
    }

    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OSelectExecutionPlan plan = new OSelectExecutionPlan(ctx);
        this.handleRidSource(plan, ctx, enableProfiling);
        this.handleSubQuerySource(plan, ctx, enableProfiling);
        this.handleFindReferences(plan, ctx, enableProfiling);
        return plan;
    }

    private void handleFindReferences(OSelectExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        List<OIdentifier> classes = this.targets == null ? null : this.targets.stream().filter(x -> x instanceof OIdentifier).map(y -> (OIdentifier)y).collect(Collectors.toList());
        List<OCluster> clusters = this.targets == null ? null : this.targets.stream().filter(x -> x instanceof OCluster).map(y -> (OCluster)y).collect(Collectors.toList());
        plan.chain(new FindReferencesStep(classes, clusters, ctx, profilingEnabled));
    }

    private void handleSubQuerySource(OSelectExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        if (this.subQuery != null) {
            new SubQueryStep(this.subQuery.createExecutionPlan(ctx, profilingEnabled), ctx, ctx, profilingEnabled);
        }
    }

    private void handleRidSource(OSelectExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        if (this.rid != null) {
            plan.chain(new FetchFromRidsStep(Collections.singleton(this.rid.toRecordId((OResult)null, ctx)), ctx, profilingEnabled));
        }
    }
}

