/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface OExecutionStepInternal
extends OExecutionStep {
    public OResultSet syncPull(OCommandContext var1, int var2) throws OTimeoutException;

    public void sendTimeout();

    public void setPrevious(OExecutionStepInternal var1);

    public void setNext(OExecutionStepInternal var1);

    public void close();

    public static String getIndent(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            for (int j = 0; j < indent; ++j) {
                result.append(" ");
            }
        }
        return result.toString();
    }

    default public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + this.getClass().getSimpleName();
    }

    @Override
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    default public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    default public String getDescription() {
        return this.prettyPrint(0, 3);
    }

    @Override
    default public String getTargetNode() {
        return "<local>";
    }

    @Override
    default public List<OExecutionStep> getSubSteps() {
        return Collections.EMPTY_LIST;
    }

    default public List<OExecutionPlan> getSubExecutionPlans() {
        return Collections.EMPTY_LIST;
    }

    default public void reset() {
    }

    default public OResult serialize() {
        throw new UnsupportedOperationException();
    }

    default public void deserialize(OResult fromResult) {
        throw new UnsupportedOperationException();
    }

    public static OResultInternal basicSerialize(OExecutionStepInternal step) {
        OResultInternal result = new OResultInternal();
        result.setProperty("javaType", step.getClass().getName());
        if (step.getSubSteps() != null && step.getSubSteps().size() > 0) {
            ArrayList<OResult> serializedSubsteps = new ArrayList<OResult>();
            for (OExecutionStep oExecutionStep : step.getSubSteps()) {
                serializedSubsteps.add(((OExecutionStepInternal)oExecutionStep).serialize());
            }
            result.setProperty("subSteps", serializedSubsteps);
        }
        if (step.getSubExecutionPlans() != null && step.getSubExecutionPlans().size() > 0) {
            ArrayList<OResult> serializedSubPlans = new ArrayList<OResult>();
            for (OExecutionPlan oExecutionPlan : step.getSubExecutionPlans()) {
                serializedSubPlans.add(((OInternalExecutionPlan)oExecutionPlan).serialize());
            }
            result.setProperty("subExecutionPlans", serializedSubPlans);
        }
        return result;
    }

    public static void basicDeserialize(OResult serialized, OExecutionStepInternal step) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        List serializedSubsteps = (List)serialized.getProperty("subSteps");
        if (serializedSubsteps != null) {
            for (OResult serializedSub : serializedSubsteps) {
                String className = (String)serializedSub.getProperty("javaType");
                OExecutionStepInternal subStep = (OExecutionStepInternal)Class.forName(className).newInstance();
                subStep.deserialize(serializedSub);
                step.getSubSteps().add(subStep);
            }
        }
        List serializedPlans = (List)serialized.getProperty("subExecutionPlans");
        if (serializedSubsteps != null) {
            for (OResult serializedSub : serializedPlans) {
                String className = (String)serializedSub.getProperty("javaType");
                OInternalExecutionPlan subStep = (OInternalExecutionPlan)Class.forName(className).newInstance();
                subStep.deserialize(serializedSub);
                step.getSubExecutionPlans().add(subStep);
            }
        }
    }

    default public OExecutionStep copy(OCommandContext ctx) {
        throw new UnsupportedOperationException();
    }

    default public boolean canBeCached() {
        return false;
    }
}

