/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OInsertSetExpression;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class InsertIntoIndexStep
extends AbstractExecutionStep {
    private final OIndexIdentifier targetIndex;
    private final OInsertBody body;
    boolean executed = false;

    public InsertIntoIndexStep(OIndexIdentifier targetIndex, OInsertBody insertBody, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetIndex = targetIndex;
        this.body = insertBody;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return !InsertIntoIndexStep.this.executed;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                OIndex<?> index = ctx.getDatabase().getMetadata().getIndexManager().getIndex(InsertIntoIndexStep.this.targetIndex.getIndexName());
                if (index == null) {
                    throw new OCommandExecutionException("Index not found: " + InsertIntoIndexStep.this.targetIndex);
                }
                List<OInsertSetExpression> setExps = InsertIntoIndexStep.this.body.getSetExpressions();
                if (InsertIntoIndexStep.this.body.getContent() != null) {
                    throw new OCommandExecutionException("Invalid expression: INSERT INTO INDEX:... CONTENT ...");
                }
                int count = setExps != null ? this.handleSet(setExps, index, ctx) : this.handleKeyValues(InsertIntoIndexStep.this.body.getIdentifierList(), InsertIntoIndexStep.this.body.getValueExpressions(), index, ctx);
                InsertIntoIndexStep.this.executed = true;
                OResultInternal result = new OResultInternal();
                result.setProperty("count", count);
                return result;
            }

            private int handleKeyValues(List<OIdentifier> identifierList, List<List<OExpression>> setExpressions, OIndex index, OCommandContext ctx2) {
                OExpression keyExp = null;
                OExpression valueExp = null;
                if (identifierList == null || setExpressions == null) {
                    throw new OCommandExecutionException("Invalid insert expression");
                }
                int count = 0;
                for (List<OExpression> valList : setExpressions) {
                    if (identifierList.size() != valList.size()) {
                        throw new OCommandExecutionException("Invalid insert expression");
                    }
                    for (int i = 0; i < identifierList.size(); ++i) {
                        OIdentifier key = identifierList.get(i);
                        if (key.getStringValue().equalsIgnoreCase("key")) {
                            keyExp = valList.get(i);
                        }
                        if (!key.getStringValue().equalsIgnoreCase("rid")) continue;
                        valueExp = valList.get(i);
                    }
                    count += this.doExecute(index, ctx2, keyExp, valueExp);
                }
                if (keyExp == null || valueExp == null) {
                    throw new OCommandExecutionException("Invalid insert expression");
                }
                return count;
            }

            private int handleSet(List<OInsertSetExpression> setExps, OIndex index, OCommandContext ctx2) {
                OExpression keyExp = null;
                OExpression valueExp = null;
                for (OInsertSetExpression exp : setExps) {
                    if (exp.getLeft().getStringValue().equalsIgnoreCase("key")) {
                        keyExp = exp.getRight();
                        continue;
                    }
                    if (exp.getLeft().getStringValue().equalsIgnoreCase("rid")) {
                        valueExp = exp.getRight();
                        continue;
                    }
                    throw new OCommandExecutionException("Cannot set " + exp + " on index");
                }
                if (keyExp == null || valueExp == null) {
                    throw new OCommandExecutionException("Invalid insert expression");
                }
                return this.doExecute(index, ctx2, keyExp, valueExp);
            }

            private int doExecute(OIndex index, OCommandContext ctx2, OExpression keyExp, OExpression valueExp) {
                int count = 0;
                Object key = keyExp.execute((OResult)null, ctx2);
                Object value = valueExp.execute((OResult)null, ctx2);
                if (value instanceof OIdentifiable) {
                    this.insertIntoIndex(index, key, (OIdentifiable)value);
                    ++count;
                } else if (value instanceof OResult && ((OResult)value).isElement()) {
                    this.insertIntoIndex(index, key, ((OResult)value).getElement().get());
                    ++count;
                } else if (value instanceof OResultSet) {
                    ((OResultSet)value).elementStream().forEach(x -> index.put(key, (OIdentifiable)x));
                } else if (OMultiValue.isMultiValue(value)) {
                    Iterator<Object> iterator = OMultiValue.getMultiValueIterator(value);
                    while (iterator.hasNext()) {
                        Object item = iterator.next();
                        if (value instanceof OIdentifiable) {
                            this.insertIntoIndex(index, key, (OIdentifiable)value);
                            ++count;
                            continue;
                        }
                        if (value instanceof OResult && ((OResult)value).isElement()) {
                            this.insertIntoIndex(index, key, ((OResult)value).getElement().get());
                            ++count;
                            continue;
                        }
                        throw new OCommandExecutionException("Cannot insert into index " + value);
                    }
                }
                return count;
            }

            private void insertIntoIndex(OIndex index, Object key, OIdentifiable value) {
                if (index instanceof OIndexMultiValues) {
                    Object rids = ((OIndexMultiValues)index).get(key);
                    if (!rids.contains(value.getIdentity())) {
                        index.put(key, value);
                    }
                } else {
                    index.put(key, value);
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }
}

