/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;

public class IndexSearchDescriptor {
    protected OIndex idx;
    protected OAndBlock keyCondition;
    protected OBinaryCondition additionalRangeCondition;
    protected OBooleanExpression remainingCondition;

    public IndexSearchDescriptor(OIndex idx, OAndBlock keyCondition, OBinaryCondition additional, OBooleanExpression remainingCondition) {
        this.idx = idx;
        this.keyCondition = keyCondition;
        this.additionalRangeCondition = additional;
        this.remainingCondition = remainingCondition;
    }

    public IndexSearchDescriptor() {
    }

    public int cost(OCommandContext ctx) {
        long val;
        OQueryStats stats = OQueryStats.get((ODatabaseDocumentInternal)ctx.getDatabase());
        String indexName = this.idx.getName();
        int size = this.keyCondition.getSubBlocks().size();
        boolean range = false;
        OBooleanExpression lastOp = this.keyCondition.getSubBlocks().get(this.keyCondition.getSubBlocks().size() - 1);
        if (lastOp instanceof OBinaryCondition) {
            OBinaryCompareOperator op = ((OBinaryCondition)lastOp).getOperator();
            range = op.isRangeOperator();
        }
        if ((val = stats.getIndexStats(indexName, size, range, this.additionalRangeCondition != null)) == -1L) {
            // empty if block
        }
        if (val >= 0L) {
            return val > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)val;
        }
        return Integer.MAX_VALUE;
    }
}

