/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterByClustersStep
extends AbstractExecutionStep {
    private Set<String> clusters;
    private Set<Integer> clusterIds;
    OResultSet prevResult = null;

    public FilterByClustersStep(Set<String> filterClusters, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.clusters = filterClusters;
        ODatabase db = ctx.getDatabase();
        this.init(db);
    }

    private void init(ODatabase db) {
        if (this.clusterIds == null) {
            this.clusterIds = this.clusters.stream().map(x -> db.getClusterIdByName((String)x)).filter(x -> x != null).collect(Collectors.toSet());
        }
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.init(ctx.getDatabase());
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        return new OResultSet(){
            public boolean finished = false;
            OResult nextItem = null;
            int fetched = 0;

            private void fetchNextItem() {
                this.nextItem = null;
                if (this.finished) {
                    return;
                }
                if (FilterByClustersStep.this.prevResult == null) {
                    FilterByClustersStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                    if (!FilterByClustersStep.this.prevResult.hasNext()) {
                        this.finished = true;
                        return;
                    }
                }
                while (!this.finished) {
                    int clusterId;
                    while (!FilterByClustersStep.this.prevResult.hasNext()) {
                        FilterByClustersStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                        if (FilterByClustersStep.this.prevResult.hasNext()) continue;
                        this.finished = true;
                        return;
                    }
                    this.nextItem = FilterByClustersStep.this.prevResult.next();
                    if (this.nextItem.isElement() && ((clusterId = this.nextItem.getIdentity().get().getClusterId()) < 0 || FilterByClustersStep.this.clusterIds.contains(clusterId))) break;
                    this.nextItem = null;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fetched >= nRecords || this.finished) {
                    return false;
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                return this.nextItem != null;
            }

            @Override
            public OResult next() {
                if (this.fetched >= nRecords || this.finished) {
                    throw new IllegalStateException();
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                if (this.nextItem == null) {
                    throw new IllegalStateException();
                }
                OResult result = this.nextItem;
                this.nextItem = null;
                ++this.fetched;
                return result;
            }

            @Override
            public void close() {
                FilterByClustersStep.this.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ FILTER ITEMS BY CLUSTERS \n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.clusters.stream().collect(Collectors.joining(", "));
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        if (this.clusters != null) {
            result.setProperty("clusters", this.clusters);
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.clusters = (Set)fromResult.getProperty("clusters");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

