/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FetchEdgesFromToVerticesStep
extends AbstractExecutionStep {
    private final OIdentifier targetClass;
    private final OIdentifier targetCluster;
    private final String fromAlias;
    private final String toAlias;
    Iterator fromIter;
    Iterator<OEdge> currentFromEdgesIter;
    Iterator toIterator;
    Set<ORID> toList = new HashSet<ORID>();
    private boolean inited = false;
    private OEdge nextEdge = null;

    public FetchEdgesFromToVerticesStep(String fromAlias, String toAlias, OIdentifier targetClass, OIdentifier targetCluster, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetClass = targetClass;
        this.targetCluster = targetCluster;
        this.fromAlias = fromAlias;
        this.toAlias = toAlias;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            int currentBatch = 0;

            @Override
            public boolean hasNext() {
                return this.currentBatch < nRecords && FetchEdgesFromToVerticesStep.this.nextEdge != null;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                OEdge edge = FetchEdgesFromToVerticesStep.this.nextEdge;
                FetchEdgesFromToVerticesStep.this.fetchNextEdge();
                OResultInternal result = new OResultInternal();
                result.setElement(edge);
                return result;
            }

            @Override
            public void close() {
                if (FetchEdgesFromToVerticesStep.this.fromIter instanceof OResultSet) {
                    ((OResultSet)FetchEdgesFromToVerticesStep.this.fromIter).close();
                }
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private OVertex asVertex(Object currentFrom) {
        if (currentFrom instanceof ORID) {
            currentFrom = ((ORID)currentFrom).getRecord();
        }
        if (currentFrom instanceof OResult) {
            return ((OResult)currentFrom).getVertex().orElse(null);
        }
        if (currentFrom instanceof OVertex) {
            return (OVertex)currentFrom;
        }
        if (currentFrom instanceof OElement) {
            return ((OElement)currentFrom).asVertex().orElse(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FetchEdgesFromToVerticesStep fetchEdgesFromToVerticesStep = this;
        synchronized (fetchEdgesFromToVerticesStep) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        Iterator<Object> fromValues = null;
        fromValues = this.ctx.getVariable(this.fromAlias);
        if (fromValues instanceof Iterable && !(fromValues instanceof OIdentifiable)) {
            fromValues = ((Iterable)((Object)fromValues)).iterator();
        } else if (!(fromValues instanceof Iterator)) {
            fromValues = Collections.singleton(fromValues).iterator();
        }
        Iterator<Object> toValues = null;
        toValues = this.ctx.getVariable(this.toAlias);
        if (toValues instanceof Iterable && !(toValues instanceof OIdentifiable)) {
            toValues = ((Iterable)((Object)toValues)).iterator();
        } else if (!(toValues instanceof Iterator)) {
            toValues = Collections.singleton(toValues).iterator();
        }
        this.fromIter = fromValues;
        Iterator<Object> toIter = toValues;
        while (toIter != null && toIter.hasNext()) {
            Object elem = toIter.next();
            if (elem instanceof OResult) {
                elem = ((OResult)elem).toElement();
            }
            if (elem instanceof OIdentifiable && !(elem instanceof OElement)) {
                elem = ((OIdentifiable)elem).getRecord();
            }
            if (!(elem instanceof OElement)) {
                throw new OCommandExecutionException("Invalid vertex: " + elem);
            }
            ((OElement)elem).asVertex().ifPresent(x -> this.toList.add(x.getIdentity()));
        }
        this.toIterator = this.toList.iterator();
        this.fetchNextEdge();
    }

    private void fetchNextEdge() {
        OEdge edge;
        this.nextEdge = null;
        while (true) {
            if (this.currentFromEdgesIter == null || !this.currentFromEdgesIter.hasNext()) {
                if (this.fromIter == null) {
                    return;
                }
                if (this.fromIter.hasNext()) {
                    Object from = this.fromIter.next();
                    if (from instanceof OResult) {
                        from = ((OResult)from).toElement();
                    }
                    if (from instanceof OIdentifiable && !(from instanceof OElement)) {
                        from = ((OIdentifiable)from).getRecord();
                    }
                    if (from instanceof OElement && ((OElement)from).isVertex()) {
                        Iterable<OEdge> edges = ((OElement)from).asVertex().get().getEdges(ODirection.OUT);
                        this.currentFromEdgesIter = edges.iterator();
                        continue;
                    }
                    throw new OCommandExecutionException("Invalid vertex: " + from);
                }
                return;
            }
            edge = this.currentFromEdgesIter.next();
            if ((this.toList == null || this.toList.contains(edge.getTo().getIdentity())) && this.matchesClass(edge) && this.matchesCluster(edge)) break;
        }
        this.nextEdge = edge;
    }

    private boolean matchesCluster(OEdge edge) {
        if (this.targetCluster == null) {
            return true;
        }
        int clusterId = edge.getIdentity().getClusterId();
        String clusterName = this.ctx.getDatabase().getClusterNameById(clusterId);
        return clusterName.equals(this.targetCluster.getStringValue());
    }

    private boolean matchesClass(OEdge edge) {
        if (this.targetClass == null) {
            return true;
        }
        return edge.getSchemaType().get().isSubClassOf(this.targetClass.getStringValue());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FOR EACH x in " + this.fromAlias + "\n";
        result = result + spaces + "    FOR EACH y in " + this.toAlias + "\n";
        result = result + spaces + "       FETCH EDGES FROM x TO y";
        if (this.targetClass != null) {
            result = result + "\n" + spaces + "       (target class " + this.targetClass + ")";
        }
        if (this.targetCluster != null) {
            result = result + "\n" + spaces + "       (target cluster " + this.targetCluster + ")";
        }
        return result;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new FetchEdgesFromToVerticesStep(this.fromAlias, this.toAlias, this.targetClass, this.targetCluster, ctx, this.profilingEnabled);
    }
}

