/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class CastToEdgeStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public CastToEdgeStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult result = upstream.next();
                long begin = CastToEdgeStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (result.getElement().orElse(null) instanceof OEdge) {
                        OResult oResult = result;
                        return oResult;
                    }
                    if (result.isEdge()) {
                        if (result instanceof OResultInternal) {
                            ((OResultInternal)result).setElement(result.getElement().get().asEdge().get());
                        } else {
                            OResultInternal r = new OResultInternal();
                            r.setElement(result.getElement().get().asEdge().get());
                            result = r;
                        }
                    } else {
                        throw new OCommandExecutionException("Current element is not a vertex: " + result);
                    }
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (CastToEdgeStep.this.profilingEnabled) {
                        CastToEdgeStep.this.cost = CastToEdgeStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ CAST TO EDGE";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new CastToEdgeStep(ctx, this.profilingEnabled);
    }

    @Override
    public boolean canBeCached() {
        return true;
    }
}

