/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLEarlyResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OFindReferenceHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLFindReferences
extends OCommandExecutorSQLEarlyResultsetAbstract {
    public static final String KEYWORD_FIND = "FIND";
    public static final String KEYWORD_REFERENCES = "REFERENCES";
    private Set<ORID> recordIds = new HashSet<ORID>();
    private String classList;
    private StringBuilder subQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandExecutorSQLFindReferences parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword(KEYWORD_FIND);
            this.parserRequiredKeyword(KEYWORD_REFERENCES);
            String target = this.parserRequiredWord(true, "Expected <target>", " =><,\r\n");
            if (target.charAt(0) == '(') {
                this.subQuery = new StringBuilder();
                this.parserSetCurrentPosition(OStringSerializerHelper.getEmbedded(this.parserText, this.parserGetPreviousPosition(), -1, this.subQuery));
            } else {
                try {
                    ORecordId rid = new ORecordId(target);
                    if (!rid.isValid()) {
                        this.throwParsingException("Record ID " + target + " is not valid");
                    }
                    this.recordIds.add(rid);
                }
                catch (IllegalArgumentException iae) {
                    throw OException.wrapException(new OCommandSQLParsingException("Error reading record Id", this.parserText, this.parserGetPreviousPosition()), iae);
                }
            }
            this.parserSkipWhiteSpaces();
            this.classList = this.parserOptionalWord(true);
            if (this.classList != null) {
                this.classList = this.parserTextUpperCase.substring(this.parserGetPreviousPosition());
                if (!this.classList.startsWith("[") || !this.classList.endsWith("]")) {
                    this.throwParsingException("Class list must be contained in []");
                }
                this.classList = this.classList.substring(1, this.classList.length() - 1);
            }
            OCommandExecutorSQLFindReferences oCommandExecutorSQLFindReferences = this;
            return oCommandExecutorSQLFindReferences;
        }
        finally {
            textRequest.setText(originalQuery);
        }
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.recordIds.isEmpty() && this.subQuery == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.subQuery != null) {
            List result = (List)new OCommandSQL(this.subQuery.toString()).execute(new Object[0]);
            for (OIdentifiable id : result) {
                this.recordIds.add(id.getIdentity());
            }
        }
        return OFindReferenceHelper.findReferences(this.recordIds, this.classList);
    }

    @Override
    public String getSyntax() {
        return "FIND REFERENCES <rid|<sub-query>> [class-list]";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }
}

