/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLCreateEdge
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "CREATE EDGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private String from;
    private String to;
    private OClass clazz;
    private String edgeLabel;
    private String clusterName;
    private List<OPair<String, Object>> fields;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateEdge parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            String temp;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLCreateEdge.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword("CREATE");
            this.parserRequiredKeyword("EDGE");
            String className = null;
            String tempLower = this.parseOptionalWord(false, new String[0]);
            String string = temp = tempLower == null ? null : tempLower.toUpperCase(Locale.ENGLISH);
            while (temp != null) {
                if (temp.equals("CLUSTER")) {
                    this.clusterName = this.parserRequiredWord(false);
                } else if (temp.equals("FROM")) {
                    this.from = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                } else if (temp.equals("TO")) {
                    this.to = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                } else if (temp.equals("SET")) {
                    this.fields = new ArrayList<OPair<String, Object>>();
                    this.parseSetFields(this.clazz, this.fields);
                } else if (temp.equals("CONTENT")) {
                    this.parseContent();
                } else if (temp.equals(KEYWORD_BATCH)) {
                    temp = this.parserNextWord(true);
                    if (temp != null) {
                        this.batch = Integer.parseInt(temp);
                    }
                } else if (className == null && temp.length() > 0) {
                    className = tempLower;
                    this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(temp);
                    if (this.clazz == null) {
                        int committed;
                        if (database.getTransaction().isActive()) {
                            OLogManager.instance().warn((Object)this, "Requested command '" + this.toString() + "' must be executed outside active transaction: the transaction will be committed and reopen right after it. To avoid this behavior execute it outside a transaction", new Object[0]);
                            committed = database.getTransaction().amountOfNestedTxs();
                            database.commit(true);
                        } else {
                            committed = 0;
                        }
                        try {
                            OSchema schema = database.getMetadata().getSchema();
                            OClass e = schema.getClass("E");
                            this.clazz = schema.createClass(className, e);
                        }
                        finally {
                            for (int i = 0; i < committed; ++i) {
                                database.begin();
                            }
                        }
                    }
                }
                temp = this.parseOptionalWord(true, new String[0]);
                if (!this.parserIsEnded()) continue;
            }
            if (className == null) {
                className = "E";
                this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(className);
            }
            if (this.clazz == null) {
                throw new OCommandSQLParsingException("Class '" + className + "' was not found");
            }
            this.edgeLabel = className;
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clazz == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal db = OCommandExecutorSQLCreateEdge.getDatabase();
        ArrayList<OEdge> edges = new ArrayList<OEdge>();
        Set<OIdentifiable> fromIds = null;
        Set<OIdentifiable> toIds = null;
        db.begin();
        try {
            fromIds = OSQLEngine.getInstance().parseRIDTarget(db, this.from, this.context, iArgs);
            toIds = OSQLEngine.getInstance().parseRIDTarget(db, this.to, this.context, iArgs);
            for (OIdentifiable from : fromIds) {
                OVertex fromVertex = this.toVertex(from);
                if (fromVertex == null) {
                    throw new OCommandExecutionException("Source vertex '" + from + "' does not exist");
                }
                for (OIdentifiable to : toIds) {
                    OVertex toVertex = from.equals(to) ? fromVertex : this.toVertex(to);
                    if (toVertex == null) {
                        throw new OCommandExecutionException("Source vertex '" + to + "' does not exist");
                    }
                    if (this.fields != null) {
                        for (OPair<String, Object> f : this.fields) {
                            if (f.getValue() instanceof OSQLFunctionRuntime) {
                                f.setValue(((OSQLFunctionRuntime)f.getValue()).getValue(to, null, this.context));
                                continue;
                            }
                            if (!(f.getValue() instanceof OSQLFilterItem)) continue;
                            f.setValue(((OSQLFilterItem)f.getValue()).getValue(to, null, this.context));
                        }
                    }
                    OEdge edge = null;
                    if (this.content != null) {
                        if (this.fields != null) {
                            this.fields.addAll(OPair.convertFromMap(this.content.toMap()));
                        } else {
                            this.fields = OPair.convertFromMap(this.content.toMap());
                        }
                    }
                    edge = fromVertex.addEdge(toVertex, this.edgeLabel);
                    if (this.fields != null && !this.fields.isEmpty()) {
                        OSQLHelper.bindParameters((ODocument)edge.getRecord(), this.fields, new OCommandParameters(iArgs), this.context);
                    }
                    edge.save(this.clusterName);
                    fromVertex.save();
                    toVertex.save();
                    edges.add(edge);
                    if (this.batch <= 0 || edges.size() % this.batch != 0) continue;
                    db.commit();
                    db.begin();
                }
            }
        }
        finally {
            db.commit();
        }
        if (edges.isEmpty()) {
            if (fromIds.isEmpty()) {
                throw new OCommandExecutionException("No edge has been created because no source vertices");
            }
            if (toIds.isEmpty()) {
                throw new OCommandExecutionException("No edge has been created because no target vertices");
            }
            throw new OCommandExecutionException("No edge has been created between " + fromIds + " and " + toIds);
        }
        return edges;
    }

    private OVertex toVertex(OIdentifiable item) {
        if (item == null) {
            return null;
        }
        if (item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        item = (OIdentifiable)OCommandExecutorSQLCreateEdge.getDatabase().load(item.getIdentity());
        if (item != null && item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        return null;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        if (this.clazz != null) {
            return Collections.singleton(OCommandExecutorSQLCreateEdge.getDatabase().getClusterNameById(this.clazz.getClusterSelection().getCluster(this.clazz, null)));
        }
        if (this.clusterName != null) {
            return this.getInvolvedClustersOfClusters(Collections.singleton(this.clusterName));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    @Override
    public String getSyntax() {
        return "CREATE EDGE [<class>] [CLUSTER <cluster>] FROM <rid>|(<query>|[<rid>]*) TO <rid>|(<query>|[<rid>]*) [SET <field> = <expression>[,]*]|CONTENT {<JSON>} [RETRY <retry> [WAIT <pauseBetweenRetriesInMs]] [BATCH <batch-size>]";
    }
}

