/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    static final String CONFIG_INDEXES = "indexes";
    private static final String DICTIONARY_NAME = "dictionary";
    final Map<String, Map<OMultiKey, Set<OIndex<?>>>> classPropertyIndex = new ConcurrentHashMap();
    protected Map<String, OIndex<?>> indexes = new ConcurrentHashMap();
    String defaultClusterName = "index";
    String manualClusterName = "manindex";
    private AtomicInteger writeLockNesting = new AtomicInteger();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public OIndexManagerAbstract() {
        super(new ODocument().setTrackingChanges(false));
    }

    public abstract void recreateIndexes(ODatabaseDocumentInternal var1);

    @Override
    public void load() {
        throw new UnsupportedOperationException();
    }

    public OIndexManagerAbstract load(ODatabaseDocumentInternal database) {
        if (!this.autoRecreateIndexesAfterCrash(database)) {
            this.acquireExclusiveLock();
            try {
                if (database.getStorage().getConfiguration().getIndexMgrRecordId() == null) {
                    this.create(database);
                }
                ((ORecordId)this.document.getIdentity()).fromString(database.getStorage().getConfiguration().getIndexMgrRecordId());
                super.reload("*:-1 index:0");
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        return this;
    }

    @Override
    public OIndexManagerAbstract reload() {
        this.acquireExclusiveLock();
        try {
            OIndexManagerAbstract oIndexManagerAbstract = (OIndexManagerAbstract)super.reload();
            return oIndexManagerAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() {
                OIndexManagerAbstract.this.acquireExclusiveLock();
                try {
                    boolean saved = false;
                    for (int retry = 0; retry < 10; ++retry) {
                        try {
                            OIndexManagerAbstract.this.toStream();
                            OIndexManagerAbstract.this.document.save();
                            saved = true;
                            break;
                        }
                        catch (OConcurrentModificationException e) {
                            OLogManager.instance().debug((Object)this, "concurrent modification while saving index manager configuration", e, new Object[0]);
                            OIndexManagerAbstract.this.reload(null, true);
                            continue;
                        }
                    }
                    if (!saved) {
                        OLogManager.instance().error(this, "failed to save the index manager configuration after 10 retries", null, new Object[0]);
                    }
                    Object var2_3 = null;
                    return var2_3;
                }
                finally {
                    OIndexManagerAbstract.this.releaseExclusiveLock();
                }
            }
        });
        return (RET)this;
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean autoRecreateIndexesAfterCrash(ODatabaseDocumentInternal var1);

    public void create(ODatabaseDocumentInternal database) {
        this.acquireExclusiveLock();
        try {
            block5: {
                try {
                    this.save("internal");
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during storing of index manager metadata, will try to allocate new document to store index manager metadata", e, new Object[0]);
                    if (!ORecordId.isPersistent(this.document.getIdentity().getClusterPosition())) break block5;
                    this.document.getIdentity().reset();
                    this.save("internal");
                }
            }
            database.getStorage().setIndexMgrRecordId(this.document.getIdentity().toString());
            OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY.toString(), null);
            this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        for (OIndex<?> idx : this.indexes.values()) {
            OIndexInternal<?> indexInternal = idx.getInternal();
            if (indexInternal == null) continue;
            indexInternal.flush();
        }
    }

    public Collection<? extends OIndex<?>> getIndexes(ODatabaseDocumentInternal database) {
        Collection<OIndex<?>> rawResult = this.indexes.values();
        ArrayList result = new ArrayList(rawResult.size());
        for (OIndex<?> index : rawResult) {
            result.add(this.preProcessBeforeReturn(database, index));
        }
        return result;
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        throw new UnsupportedOperationException();
    }

    public OIndex<?> getRawIndex(String iName) {
        OIndex<?> index = this.indexes.get(iName);
        if (index == null) {
            return null;
        }
        return index;
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        OIndex<?> index = this.indexes.get(iName);
        if (index == null) {
            return null;
        }
        return this.preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), index);
    }

    @Override
    public void addClusterToIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName);
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        if (index.getInternal() == null) {
            throw new OIndexException("Index with name " + indexName + " has no internal presentation.");
        }
        if (!index.getInternal().getClusters().contains(clusterName)) {
            index.getInternal().addCluster(clusterName);
            this.save();
        }
    }

    @Override
    public void removeClusterFromIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName);
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        index.getInternal().removeCluster(clusterName);
        this.save();
    }

    @Override
    public boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName);
    }

    @Override
    public String getDefaultClusterName() {
        this.acquireSharedLock();
        try {
            String string = this.defaultClusterName;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        this.acquireExclusiveLock();
        try {
            this.defaultClusterName = defaultClusterName;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        OIndex<OIdentifiable> idx;
        this.acquireSharedLock();
        try {
            idx = this.getIndex(DICTIONARY_NAME);
        }
        finally {
            this.releaseSharedLock();
        }
        if (idx == null) {
            idx = this.createDictionaryIfNeeded();
        }
        return new ODictionary<ORecord>(idx);
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.getDocument();
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void close() {
        this.indexes.clear();
        this.classPropertyIndex.clear();
    }

    void setDirty() {
        this.acquireExclusiveLock();
        try {
            this.document.setDirty();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        OMultiKey multiKey = new OMultiKey(fields);
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(className);
        if (propertyIndex == null || !propertyIndex.containsKey(multiKey)) {
            return Collections.emptySet();
        }
        Set<OIndex<?>> rawResult = propertyIndex.get(multiKey);
        HashSet transactionalResult = new HashSet(rawResult.size());
        for (OIndex<?> index : rawResult) {
            if (fields.size() != index.getDefinition().getFields().size() && index.getDefinition().isNullValuesIgnored()) continue;
            transactionalResult.add(this.preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), index));
        }
        return transactionalResult;
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return this.getClassInvolvedIndexes(className, Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        OMultiKey multiKey = new OMultiKey(fields);
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(className);
        if (propertyIndex == null) {
            return false;
        }
        return propertyIndex.containsKey(multiKey) && !propertyIndex.get(multiKey).isEmpty();
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return this.areIndexed(className, Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        HashSet coll = new HashSet(4);
        this.getClassIndexes(className, coll);
        return coll;
    }

    @Override
    public void getClassIndexes(String className, Collection<OIndex<?>> indexes) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(className);
        if (propertyIndex == null) {
            return;
        }
        for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
            for (OIndex<?> index : propertyIndexes) {
                indexes.add(this.preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), index));
            }
        }
    }

    public void getClassRawIndexes(String className, Collection<OIndex<?>> indexes) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(className);
        if (propertyIndex == null) {
            return;
        }
        for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
            indexes.addAll(propertyIndexes);
        }
    }

    @Override
    public OIndexUnique getClassUniqueIndex(String className) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(className);
        if (propertyIndex != null) {
            for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
                for (OIndex<?> index : propertyIndexes) {
                    if (!(index instanceof OIndexUnique)) continue;
                    return (OIndexUnique)index;
                }
            }
        }
        return null;
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        Locale locale = this.getServerLocale();
        className = className.toLowerCase(locale);
        OIndex<?> index = this.indexes.get(indexName);
        if (index != null && index.getDefinition() != null && index.getDefinition().getClassName() != null && className.equals(index.getDefinition().getClassName().toLowerCase(locale))) {
            return this.preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), index);
        }
        return null;
    }

    @Override
    public OIndex<?> getClassAutoShardingIndex(String className) {
        Locale locale = this.getServerLocale();
        className = className.toLowerCase(locale);
        for (OIndex<?> index : this.indexes.values()) {
            if (index == null || !"AUTOSHARDING".equals(index.getAlgorithm()) || index.getDefinition() == null || index.getDefinition().getClassName() == null || !className.equals(index.getDefinition().getClassName().toLowerCase(locale))) continue;
            return this.preProcessBeforeReturn(OIndexManagerAbstract.getDatabase(), index);
        }
        return null;
    }

    private void acquireSharedLock() {
        this.lock.readLock().lock();
    }

    private void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() {
        this.internalAcquireExclusiveLock();
        this.writeLockNesting.incrementAndGet();
    }

    void internalAcquireExclusiveLock() {
        OMetadataInternal metadata;
        ODatabaseDocumentInternal databaseRecord = OIndexManagerAbstract.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = (OMetadataInternal)databaseRecord.getMetadata()) != null) {
            metadata.makeThreadLocalSchemaSnapshot();
        }
        this.lock.writeLock().lock();
    }

    protected void releaseExclusiveLock() {
        int val = this.writeLockNesting.decrementAndGet();
        this.internalReleaseExclusiveLock();
        if (val == 0) {
            ODatabaseDocumentInternal database = OIndexManagerAbstract.getDatabase();
            for (OMetadataUpdateListener listener : database.getSharedContext().browseListeners()) {
                listener.onIndexManagerUpdate(database.getName(), this);
            }
        }
    }

    void internalReleaseExclusiveLock() {
        OMetadata metadata;
        this.lock.writeLock().unlock();
        ODatabaseDocumentInternal databaseRecord = OIndexManagerAbstract.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = databaseRecord.getMetadata()) != null) {
            ((OMetadataInternal)metadata).clearThreadLocalSchemaSnapshot();
        }
    }

    void clearMetadata() {
        this.acquireExclusiveLock();
        try {
            this.indexes.clear();
            this.classPropertyIndex.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    protected abstract OStorage getStorage();

    private static ODatabaseDocumentInternal getDatabaseIfDefined() {
        return ODatabaseRecordThreadLocal.instance().getIfDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIndexInternal(OIndex<?> index) {
        this.acquireExclusiveLock();
        try {
            Locale locale = this.getServerLocale();
            this.indexes.put(index.getName(), index);
            OIndexDefinition indexDefinition = index.getDefinition();
            if (indexDefinition == null || indexDefinition.getClassName() == null) {
                return;
            }
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.getIndexOnProperty(indexDefinition.getClassName());
            propertyIndex = propertyIndex == null ? new HashMap() : new HashMap(propertyIndex);
            int paramCount = indexDefinition.getParamCount();
            for (int i = 1; i <= paramCount; ++i) {
                List<String> fields = indexDefinition.getFields().subList(0, i);
                OMultiKey multiKey = new OMultiKey(fields);
                Set<OIndex<?>> indexSet = propertyIndex.get(multiKey);
                indexSet = indexSet == null ? new HashSet() : new HashSet(indexSet);
                indexSet.add(index);
                propertyIndex.put(multiKey, indexSet);
            }
            this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(locale), OIndexManagerAbstract.copyPropertyMap(propertyIndex));
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    static Map<OMultiKey, Set<OIndex<?>>> copyPropertyMap(Map<OMultiKey, Set<OIndex<?>>> original) {
        HashMap result = new HashMap();
        for (Map.Entry<OMultiKey, Set<OIndex<?>>> entry : original.entrySet()) {
            HashSet indexes = new HashSet(entry.getValue());
            assert (indexes.equals(entry.getValue()));
            result.put(entry.getKey(), Collections.unmodifiableSet(indexes));
        }
        assert (result.equals(original));
        return Collections.unmodifiableMap(result);
    }

    public abstract OIndex<?> preProcessBeforeReturn(ODatabaseDocumentInternal var1, OIndex<?> var2);

    private OIndex<?> createDictionaryIfNeeded() {
        this.acquireExclusiveLock();
        try {
            OIndex<?> idx = this.getIndex(DICTIONARY_NAME);
            OIndex<?> oIndex = idx != null ? idx : this.createDictionary();
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private OIndex<?> createDictionary() {
        OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY.toString(), null);
        return this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null, null);
    }

    Locale getServerLocale() {
        OStorage storage = this.getStorage();
        OStorageConfiguration configuration = storage.getConfiguration();
        return configuration.getLocaleInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<OMultiKey, Set<OIndex<?>>> getIndexOnProperty(String className) {
        Locale locale = this.getServerLocale();
        this.acquireSharedLock();
        try {
            Map<OMultiKey, Set<OIndex<?>>> map = this.classPropertyIndex.get(className.toLowerCase(locale));
            return map;
        }
        finally {
            this.releaseSharedLock();
        }
    }
}

