/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.chm.AsyncReadCache;
import com.orientechnologies.orient.core.storage.cache.local.twoq.O2QCache;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class OEngineLocalPaginated
extends OEngineAbstract {
    public static final String NAME = "plocal";
    private volatile OReadCache readCache;
    protected final OClosableLinkedContainer<Long, OFileClassic> files = new OClosableLinkedContainer(OEngineLocalPaginated.getOpenFilesLimit());

    private static int getOpenFilesLimit() {
        if (OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger() > 0) {
            OLogManager.instance().infoNoDb(OEngineLocalPaginated.class, "Limit of open files for disk cache will be set to %d.", OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger());
            return OGlobalConfiguration.OPEN_FILES_LIMIT.getValueAsInteger();
        }
        int defaultLimit = 512;
        int recommendedLimit = 262144;
        return ONative.instance().getOpenFilesLimit(true, 262144, 512);
    }

    @Override
    public void startup() {
        String userName = System.getProperty("user.name", "unknown");
        OLogManager.instance().infoNoDb(this, "System is started under an effective user : `%s`", userName);
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        super.startup();
        long diskCacheSize = OEngineLocalPaginated.calculateReadCacheMaxMemory(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L);
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        if (OGlobalConfiguration.DIRECT_MEMORY_PREALLOCATE.getValueAsBoolean()) {
            int pageCount = (int)(diskCacheSize / (long)pageSize);
            OLogManager.instance().info((Object)this, "Allocation of " + pageCount + " pages.", new Object[0]);
            OByteBufferPool bufferPool = OByteBufferPool.instance(null);
            ArrayList<OPointer> pages = new ArrayList<OPointer>(pageCount);
            for (int i = 0; i < pageCount; ++i) {
                pages.add(bufferPool.acquireDirect(false));
            }
            for (OPointer pointer : pages) {
                bufferPool.release(pointer);
            }
            pages.clear();
        }
        this.readCache = OGlobalConfiguration.USE_CHM_CACHE.getValueAsBoolean() ? new AsyncReadCache(OByteBufferPool.instance(null), diskCacheSize, pageSize, OGlobalConfiguration.DISK_CACHE_PRINT_CACHE_STATISTICS.getValueAsBoolean()) : new O2QCache(diskCacheSize, pageSize, true, OGlobalConfiguration.DISK_CACHE_PINNED_PAGES.getValueAsInteger(), OGlobalConfiguration.DISK_CACHE_PRINT_CACHE_STATISTICS.getValueAsBoolean(), OGlobalConfiguration.DISK_CACHE_STATISTICS_INTERVAL.getValueAsInteger());
    }

    private static long calculateReadCacheMaxMemory(long cacheSize) {
        return (long)((double)cacheSize * ((double)(100 - OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger()) / 100.0));
    }

    public void changeCacheSize(long cacheSize) {
        if (this.readCache != null) {
            this.readCache.changeMaximumAmountOfMemory(OEngineLocalPaginated.calculateReadCacheMaxMemory(cacheSize));
        }
    }

    @Override
    public OStorage createStorage(String dbName, Map<String, String> configuration, long maxWalSegSize) {
        try {
            return new OLocalPaginatedStorage(dbName, dbName, this.getMode(configuration), this.generateStorageId(), this.readCache, this.files, maxWalSegSize);
        }
        catch (Exception e) {
            String message = "Error on opening database: " + dbName + ". Current location is: " + new File(".").getAbsolutePath();
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new ODatabaseException(message), e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public OReadCache getReadCache() {
        return this.readCache;
    }

    @Override
    public String getNameFromPath(String dbPath) {
        return OIOUtils.getRelativePathIfAny(dbPath, null);
    }

    @Override
    public void shutdown() {
        try {
            this.readCache.clear();
            this.files.clear();
        }
        finally {
            super.shutdown();
        }
    }
}

