/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OUTF8Serializer
implements OBinarySerializer<String> {
    private static final int INT_MASK = 65535;
    public static final OUTF8Serializer INSTANCE = new OUTF8Serializer();
    public static final byte ID = 25;

    @Override
    public int getObjectSize(String object, Object ... hints) {
        byte[] encoded = object.getBytes(StandardCharsets.UTF_8);
        return 2 + encoded.length;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return (OShortSerializer.INSTANCE.deserialize(stream, startPosition) & 0xFFFF) + 2;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition, Object ... hints) {
        byte[] encoded = object.getBytes(StandardCharsets.UTF_8);
        OShortSerializer.INSTANCE.serialize((short)encoded.length, stream, startPosition, new Object[0]);
        System.arraycopy(encoded, 0, stream, startPosition += 2, encoded.length);
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        int encodedSize = OShortSerializer.INSTANCE.deserialize(stream, startPosition) & 0xFFFF;
        byte[] encoded = new byte[encodedSize];
        System.arraycopy(stream, startPosition += 2, encoded, 0, encodedSize);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    @Override
    public byte getId() {
        return 25;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public void serializeNativeObject(String object, byte[] stream, int startPosition, Object ... hints) {
        byte[] encoded = object.getBytes(StandardCharsets.UTF_8);
        OShortSerializer.INSTANCE.serializeNative((short)encoded.length, stream, startPosition, new Object[0]);
        System.arraycopy(encoded, 0, stream, startPosition += 2, encoded.length);
    }

    @Override
    public String deserializeNativeObject(byte[] stream, int startPosition) {
        int encodedSize = OShortSerializer.INSTANCE.deserializeNative(stream, startPosition) & 0xFFFF;
        byte[] encoded = new byte[encodedSize];
        System.arraycopy(stream, startPosition += 2, encoded, 0, encodedSize);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return (OShortSerializer.INSTANCE.deserializeNative(stream, startPosition) & 0xFFFF) + 2;
    }

    @Override
    public String preprocess(String value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(String object, ByteBuffer buffer, Object ... hints) {
        byte[] encoded = object.getBytes(Charset.forName("UTF-8"));
        buffer.putShort((short)encoded.length);
        buffer.put(encoded);
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer) {
        int encodedSize = buffer.getShort() & 0xFFFF;
        byte[] encoded = new byte[encodedSize];
        buffer.get(encoded);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return (buffer.getShort() & 0xFFFF) + 2;
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int encodedSize = walChanges.getShortValue(buffer, offset) & 0xFFFF;
        byte[] encoded = walChanges.getBinaryValue(buffer, offset += 2, encodedSize);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return (walChanges.getShortValue(buffer, offset) & 0xFFFF) + 2;
    }

    @Override
    public byte[] serializeNativeAsWhole(String object, Object ... hints) {
        byte[] encoded = object.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[encoded.length + 2];
        OShortSerializer.INSTANCE.serializeNative((short)encoded.length, result, 0, new Object[0]);
        System.arraycopy(encoded, 0, result, 2, encoded.length);
        return result;
    }
}

