/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;

public class ODateTimeSerializer
implements OBinarySerializer<Date> {
    public static final byte ID = 5;
    public static final ODateTimeSerializer INSTANCE = new ODateTimeSerializer();

    @Override
    public int getObjectSize(Date object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer.INSTANCE.serializeLiteral(calendar.getTimeInMillis(), stream, startPosition);
    }

    @Override
    public Date deserialize(byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(OLongSerializer.INSTANCE.deserializeLiteral(stream, startPosition));
        return calendar.getTime();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNativeObject(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer.INSTANCE.serializeNative(calendar.getTimeInMillis(), stream, startPosition, new Object[0]);
    }

    @Override
    public Date deserializeNativeObject(byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(OLongSerializer.INSTANCE.deserializeNative(stream, startPosition));
        return calendar.getTime();
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Date preprocess(Date value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Date object, ByteBuffer buffer, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        buffer.putLong(calendar.getTimeInMillis());
    }

    @Override
    public Date deserializeFromByteBufferObject(ByteBuffer buffer) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(buffer.getLong());
        return calendar.getTime();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 8;
    }

    @Override
    public Date deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(walChanges.getLongValue(buffer, offset));
        return calendar.getTime();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 8;
    }
}

