/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.io;

import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.util.OPatternConst;
import com.sun.jna.LastErrorException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class OIOUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long YEAR = 31536000000L;
    public static final long WEEK = 604800000L;
    public static final String UTF8_BOM = "\ufeff";

    public static long getTimeAsMillisecs(Object iSize) {
        if (iSize == null) {
            throw new IllegalArgumentException("Time is null");
        }
        if (iSize instanceof Number) {
            return ((Number)iSize).longValue();
        }
        String time = iSize.toString();
        boolean number = true;
        for (int i = time.length() - 1; i >= 0; --i) {
            if (Character.isDigit(time.charAt(i))) continue;
            number = false;
            break;
        }
        if (number) {
            return Long.parseLong(time);
        }
        time = time.toUpperCase(Locale.ENGLISH);
        int pos = time.indexOf("MS");
        String timeAsNumber = OPatternConst.PATTERN_NUMBERS.matcher(time).replaceAll("");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber);
        }
        pos = time.indexOf("S");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 1000L;
        }
        pos = time.indexOf("M");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 60000L;
        }
        pos = time.indexOf("H");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 3600000L;
        }
        pos = time.indexOf("D");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 86400000L;
        }
        pos = time.indexOf(87);
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 604800000L;
        }
        pos = time.indexOf(89);
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 31536000000L;
        }
        throw new IllegalArgumentException("Time '" + time + "' has a unrecognizable format");
    }

    public static String getTimeAsString(long iTime) {
        if (iTime > 31536000000L && iTime % 31536000000L == 0L) {
            return String.format("%dy", iTime / 31536000000L);
        }
        if (iTime > 604800000L && iTime % 604800000L == 0L) {
            return String.format("%dw", iTime / 604800000L);
        }
        if (iTime > 86400000L && iTime % 86400000L == 0L) {
            return String.format("%dd", iTime / 86400000L);
        }
        if (iTime > 3600000L && iTime % 3600000L == 0L) {
            return String.format("%dh", iTime / 3600000L);
        }
        if (iTime > 60000L && iTime % 60000L == 0L) {
            return String.format("%dm", iTime / 60000L);
        }
        if (iTime > 1000L && iTime % 1000L == 0L) {
            return String.format("%ds", iTime / 1000L);
        }
        return String.format("%dms", iTime);
    }

    public static Date getTodayWithTime(String iTime) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        Calendar calParsed = Calendar.getInstance();
        calParsed.setTime(df.parse(iTime));
        Calendar cal = Calendar.getInstance();
        cal.set(11, calParsed.get(11));
        cal.set(12, calParsed.get(12));
        cal.set(13, calParsed.get(13));
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String readFileAsString(File iFile) throws IOException {
        return OIOUtils.readStreamAsString(new FileInputStream(iFile));
    }

    public static String readFileAsString(File iFile, Charset iCharset) throws IOException {
        return OIOUtils.readStreamAsString(new FileInputStream(iFile), iCharset);
    }

    public static String readStreamAsString(InputStream iStream) throws IOException {
        return OIOUtils.readStreamAsString(iStream, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream iStream, Charset iCharset) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(iStream, iCharset));){
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                if (fileData.length() == 0 && readData.startsWith(UTF8_BOM)) {
                    readData = readData.substring(1);
                }
                fileData.append(readData);
            }
        }
        return fileData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File iFile, String iContent) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(iFile);
             OutputStreamWriter os = new OutputStreamWriter(fos);
             BufferedWriter writer = new BufferedWriter(os);){
            writer.write(iContent);
        }
    }

    public static long copyStream(InputStream in, OutputStream out, long iMax) throws IOException {
        if (iMax < 0L) {
            iMax = Long.MAX_VALUE;
        }
        byte[] buf = new byte[8192];
        int byteRead = 0;
        long byteTotal = 0L;
        while ((byteRead = in.read(buf, 0, (int)Math.min((long)buf.length, iMax - byteTotal))) > 0) {
            out.write(buf, 0, byteRead);
            byteTotal += (long)byteRead;
        }
        return byteTotal;
    }

    public static String getUnixFileName(String iFileName) {
        return iFileName != null ? iFileName.replace('\\', '/') : null;
    }

    public static String getRelativePathIfAny(String iDatabaseURL, String iBasePath) {
        if (iBasePath == null) {
            int pos = iDatabaseURL.lastIndexOf(47);
            if (pos > -1) {
                return iDatabaseURL.substring(pos + 1);
            }
        } else {
            int pos = iDatabaseURL.indexOf(iBasePath);
            if (pos > -1) {
                return iDatabaseURL.substring(pos + iBasePath.length() + 1);
            }
        }
        return iDatabaseURL;
    }

    public static String getDatabaseNameFromPath(String iPath) {
        return iPath.replace('/', '$');
    }

    public static String getPathFromDatabaseName(String iPath) {
        return iPath.replace('$', '/');
    }

    public static String getStringMaxLength(String iText, int iMax) {
        return OIOUtils.getStringMaxLength(iText, iMax, "");
    }

    public static String getStringMaxLength(String iText, int iMax, String iOther) {
        if (iText == null) {
            return null;
        }
        if (iMax > iText.length()) {
            return iText;
        }
        return iText.substring(0, iMax) + iOther;
    }

    public static Object encode(Object iValue) {
        if (iValue instanceof String) {
            return OIOUtils.java2unicode(((String)iValue).replace("\\", "\\\\").replace("\"", "\\\""));
        }
        return iValue;
    }

    public static String java2unicode(String iInput) {
        StringBuilder result = new StringBuilder(iInput.length() * 2);
        int inputSize = iInput.length();
        for (int i = 0; i < inputSize; ++i) {
            char ch = iInput.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                result.append(ch);
                continue;
            }
            result.append("\\u");
            String hex = Integer.toHexString(ch & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                result.append('0');
            }
            result.append(hex.toLowerCase(Locale.ENGLISH));
        }
        return result.toString();
    }

    public static boolean isStringContent(Object iValue) {
        if (iValue == null) {
            return false;
        }
        String s = iValue.toString();
        if (s == null) {
            return false;
        }
        return s.length() > 1 && (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"');
    }

    public static String getStringContent(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String s = iValue.toString();
        if (s == null) {
            return null;
        }
        if (s.length() > 1 && (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        if (s.length() > 1 && s.charAt(0) == '`' && s.charAt(s.length() - 1) == '`') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String wrapStringContent(Object iValue, char iStringDelimiter) {
        if (iValue == null) {
            return null;
        }
        String s = iValue.toString();
        if (s == null) {
            return null;
        }
        return iStringDelimiter + s + iStringDelimiter;
    }

    public static boolean equals(byte[] buffer, byte[] buffer2) {
        if (buffer == null || buffer2 == null || buffer.length != buffer2.length) {
            return false;
        }
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == buffer2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isLong(String iText) {
        char c;
        boolean isLong = true;
        int size = iText.length();
        for (int i = 0; i < size && isLong; isLong &= (c = iText.charAt(i)) >= '0' && c <= '9', ++i) {
        }
        return isLong;
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = in.read(b, off, len);
            if (n == -1) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    public static void readByteBuffer(ByteBuffer buffer, FileChannel channel, long position, boolean throwOnEof) throws IOException {
        int r;
        int bytesToRead = buffer.limit();
        for (int read = 0; read < bytesToRead; read += r) {
            buffer.position(read);
            r = channel.read(buffer, position + (long)read);
            if (r >= 0) continue;
            if (throwOnEof) {
                throw new EOFException("End of file is reached");
            }
            buffer.put(new byte[buffer.remaining()]);
            return;
        }
    }

    public static void readByteBuffer(ByteBuffer buffer, FileChannel channel) throws IOException {
        int r;
        int bytesToRead = buffer.limit();
        for (int read = 0; read < bytesToRead; read += r) {
            buffer.position(read);
            r = channel.read(buffer);
            if (r >= 0) continue;
            throw new EOFException("End of file is reached");
        }
    }

    public static void readByteBuffer(ByteBuffer buffer, int fd) throws IOException {
        int read;
        int r;
        int bytesToRead = buffer.limit();
        for (read = 0; read < bytesToRead; read += r) {
            buffer.position(read);
            try {
                r = (int)ONative.instance().read(fd, buffer, buffer.remaining());
            }
            catch (LastErrorException e) {
                throw new IOException("Error during reading from file", e);
            }
            if (r >= 0) continue;
            throw new EOFException("End of file is reached");
        }
        buffer.position(read);
    }

    public static void writeByteBuffer(ByteBuffer buffer, FileChannel channel, long position) throws IOException {
        int bytesToWrite = buffer.limit();
        for (int written = 0; written < bytesToWrite; written += channel.write(buffer, position + (long)written)) {
            buffer.position(written);
        }
    }

    public static void writeByteBuffers(ByteBuffer[] buffers, FileChannel channel, long bytesToWrite) throws IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            buffer.position(0);
        }
        int bufferLimit = buffers[0].limit();
        while (written < bytesToWrite) {
            int bufferIndex = (int)written / bufferLimit;
            written += channel.write(buffers, bufferIndex, buffers.length - bufferIndex);
        }
    }

    public static void readByteBuffers(ByteBuffer[] buffers, FileChannel channel, long bytesToRead, boolean throwOnEof) throws IOException {
        long read = 0L;
        for (ByteBuffer buffer : buffers) {
            buffer.position(0);
        }
        int bufferLimit = buffers[0].limit();
        while (read < bytesToRead) {
            int bufferIndex = (int)read / bufferLimit;
            long r = channel.read(buffers, bufferIndex, buffers.length - bufferIndex);
            if (r < 0L) {
                if (throwOnEof) {
                    throw new EOFException("End of file is reached");
                }
                for (int i = bufferIndex; i < buffers.length; ++i) {
                    buffers[i].put(new byte[buffers[i].remaining()]);
                }
                return;
            }
            read += r;
        }
    }
}

