/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OLowerPhysicalPositionsRequest
implements OBinaryRequest<OLowerPhysicalPositionsResponse> {
    private OPhysicalPosition physicalPosition;
    private int iClusterId;

    public OLowerPhysicalPositionsRequest(OPhysicalPosition physicalPosition, int iClusterId) {
        this.physicalPosition = physicalPosition;
        this.iClusterId = iClusterId;
    }

    public OLowerPhysicalPositionsRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.iClusterId);
        network.writeLong(this.physicalPosition.clusterPosition);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.iClusterId = channel.readInt();
        this.physicalPosition = new OPhysicalPosition(channel.readLong());
    }

    @Override
    public byte getCommand() {
        return 37;
    }

    @Override
    public String getDescription() {
        return "Retrieve lower positions";
    }

    public int getiClusterId() {
        return this.iClusterId;
    }

    public OPhysicalPosition getPhysicalPosition() {
        return this.physicalPosition;
    }

    @Override
    public OLowerPhysicalPositionsResponse createResponse() {
        return new OLowerPhysicalPositionsResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeLowerPosition(this);
    }
}

