/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class keywordLoader {
    private static Map<EDbVendor, Properties> keywordMap = new HashMap<EDbVendor, Properties>();

    keywordLoader() {
    }

    private static synchronized void loadKeywordList(EDbVendor vendor) {
        if (vendor != null && !keywordMap.containsKey((Object)vendor)) {
            String vendorString = null;
            switch (vendor) {
                case dbvaccess: {
                    vendorString = "access";
                    break;
                }
                case dbvfirebird: {
                    vendorString = "firebird";
                    break;
                }
                case dbvgeneric: {
                    vendorString = "generic";
                    break;
                }
                case dbvinformix: {
                    vendorString = "informix";
                    break;
                }
                case dbvhive: {
                    vendorString = "hive";
                    break;
                }
                case dbvimpala: {
                    vendorString = "impala";
                    break;
                }
                case dbvsnowflake: {
                    vendorString = "snowflake";
                    break;
                }
                case dbvredshift: {
                    vendorString = "redshift";
                    break;
                }
                case dbvgreenplum: {
                    vendorString = "greenplum";
                    break;
                }
                case dbvmdx: {
                    vendorString = "mdx";
                    break;
                }
                case dbvnetezza: {
                    vendorString = "netezza";
                    break;
                }
                case dbvmssql: {
                    vendorString = "mssql";
                    break;
                }
                case dbvoracle: {
                    vendorString = "oracle";
                    break;
                }
                case dbvmysql: {
                    vendorString = "mysql";
                    break;
                }
                case dbvdb2: {
                    vendorString = "db2";
                    break;
                }
                case dbvpostgresql: {
                    vendorString = "postgresql";
                    break;
                }
                case dbvsybase: {
                    vendorString = "sybase";
                    break;
                }
                case dbvteradata: {
                    vendorString = "teradata";
                    break;
                }
                case dbvansi: {
                    vendorString = "ansi";
                    break;
                }
                case dbvodbc: {
                    vendorString = "odbc";
                    break;
                }
                case dbvbigquery: {
                    vendorString = "bigquery";
                    break;
                }
                case dbvcouchbase: {
                    vendorString = "couchbase";
                    break;
                }
                case dbvhana: {
                    vendorString = "hana";
                    break;
                }
                case dbvvertica: {
                    vendorString = "vertica";
                }
            }
            InputStream is = keywordLoader.class.getResourceAsStream("/gudusoft/gsqlparser/util/" + vendorString + "_keyword.properties");
            if (is != null) {
                Properties properties = new Properties();
                try {
                    properties.load(is);
                    keywordMap.put(vendor, properties);
                    return;
                }
                catch (IOException e) {
                    Logger.getLogger(keywordLoader.class.getName()).log(Level.WARNING, "Load " + vendorString + ".properties" + " failed.", e);
                }
            } else {
                Logger.getLogger(keywordLoader.class.getName()).log(Level.WARNING, "Doesn't implement " + (Object)((Object)vendor));
            }
            keywordMap.put(vendor, null);
        }
    }

    public static Properties getKeywordList(EDbVendor vendor) {
        keywordLoader.loadKeywordList(vendor);
        return keywordMap.get((Object)vendor);
    }
}

