/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.util.keywordList;
import gudusoft.gsqlparser.util.keywordLoader;
import gudusoft.gsqlparser.util.keywordMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

class keywordListFactory {
    private HashMap<EDbVendor, keywordMap> dbKeywordListMap = new HashMap();
    private Object object = new Object();

    public static final keywordListFactory getInstance() {
        return SingletonContainer.instance;
    }

    public keywordList getDbKeywordList(EDbVendor dbvendor, String dbVersion) {
        this.loadDbKeywordList(dbvendor);
        keywordMap dbKeyword = this.dbKeywordListMap.get((Object)dbvendor);
        if (dbKeyword != null) {
            return dbKeyword.getDbKeywordList(dbVersion);
        }
        return null;
    }

    public List<String> getAvailableDbVersions(EDbVendor dbvendor) {
        this.loadDbKeywordList(dbvendor);
        keywordMap dbKeyword = this.dbKeywordListMap.get((Object)dbvendor);
        if (dbKeyword != null) {
            return dbKeyword.getDbVersions();
        }
        return null;
    }

    public boolean containsDbVersion(EDbVendor dbvendor, String dbVersion) {
        this.loadDbKeywordList(dbvendor);
        keywordMap dbKeyword = this.dbKeywordListMap.get((Object)dbvendor);
        if (dbKeyword != null && dbVersion != null) {
            return dbKeyword.containsVersion(dbVersion);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDbKeywordList(EDbVendor dbvendor) {
        if (this.dbKeywordListMap.containsKey((Object)dbvendor)) {
            return;
        }
        Object object = this.object;
        synchronized (object) {
            if (this.dbKeywordListMap.containsKey((Object)dbvendor)) {
                return;
            }
            keywordMap dbKeywordMap = new keywordMap();
            Properties properties = keywordLoader.getKeywordList(dbvendor);
            if (properties != null) {
                String[] keys = properties.keySet().toArray(new String[0]);
                ArrayList<String> versions = new ArrayList<String>();
                for (int i = 0; i < keys.length; ++i) {
                    String version;
                    String key = keys[i];
                    int index = key.indexOf(95);
                    if (index == -1 || versions.contains(version = key.substring(0, index).toUpperCase())) continue;
                    versions.add(version);
                }
                for (String version : versions) {
                    String allKey;
                    keywordList keywordList2 = new keywordList(dbvendor);
                    String reservedKey = version + "_reserved";
                    if (properties.containsKey(reservedKey)) {
                        String[] keywords = properties.getProperty(reservedKey).split(",");
                        for (int i = 0; i < keywords.length; ++i) {
                            String keyword = keywords[i].trim().toUpperCase();
                            if (keywordList2.getReservedList().contains(keyword)) continue;
                            keywordList2.getReservedList().add(keyword);
                        }
                        Collections.sort(keywordList2.getReservedList());
                    }
                    if (properties.containsKey(allKey = version + "_all")) {
                        String[] keywords = properties.getProperty(allKey).split(",");
                        for (int i = 0; i < keywords.length; ++i) {
                            String keyword = keywords[i].trim().toUpperCase();
                            if (keywordList2.getKeywordList().contains(keyword)) continue;
                            keywordList2.getKeywordList().add(keyword);
                        }
                        Collections.sort(keywordList2.getKeywordList());
                    } else {
                        keywordList2.getKeywordList().addAll(keywordList2.getReservedList());
                    }
                    dbKeywordMap.setDbKeywordList(version, keywordList2);
                }
            }
            this.dbKeywordListMap.put(dbvendor, dbKeywordMap);
        }
    }

    private keywordListFactory() {
    }

    private static class SingletonContainer {
        private static final keywordListFactory instance = new keywordListFactory();

        private SingletonContainer() {
        }
    }
}

