/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.util.keywordList;
import gudusoft.gsqlparser.util.keywordListFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class keywordChecker {
    private static final String COMMA = ",";
    private static final String MINUS = "-";

    private keywordChecker() {
    }

    public static boolean isKeyword(String inputString, EDbVendor dbvendor, String dbVersion, boolean reservedOnly) {
        if (inputString == null || inputString.trim().equals("")) {
            return false;
        }
        String keyword = inputString.toUpperCase();
        keywordList keywordList2 = keywordListFactory.getInstance().getDbKeywordList(dbvendor, dbVersion);
        if (keywordList2 == null) {
            throw new IllegalArgumentException("Can't get available keyword list");
        }
        if (reservedOnly) {
            return keywordList2.getReservedList().contains(keyword);
        }
        return keywordList2.getKeywordList().contains(keyword);
    }

    public static String getKeywordList(EDbVendor dbvendor, String dbVersion, boolean reservedOnly) {
        keywordList keywordList2 = keywordListFactory.getInstance().getDbKeywordList(dbvendor, dbVersion);
        if (keywordList2 == null) {
            throw new IllegalArgumentException("Can't get available keyword list");
        }
        List<String> keywords = null;
        keywords = reservedOnly ? keywordList2.getReservedList() : keywordList2.getKeywordList();
        if (keywords != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < keywords.size(); ++i) {
                if (i < keywords.size() - 1) {
                    buffer.append(keywords.get(i)).append(COMMA);
                    continue;
                }
                buffer.append(keywords.get(i));
            }
            return buffer.toString();
        }
        return null;
    }

    public static String compareKeywordList(EDbVendor dbvendor1, String dbVersion1, EDbVendor dbvendor2, String dbVersion2, boolean reservedOnly) {
        keywordList keywordList1 = keywordListFactory.getInstance().getDbKeywordList(dbvendor1, dbVersion1);
        keywordList keywordList2 = keywordListFactory.getInstance().getDbKeywordList(dbvendor2, dbVersion2);
        if (keywordList1 == null || keywordList2 == null) {
            throw new IllegalArgumentException("Can't get available keyword list");
        }
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        ArrayList<String> retainList = new ArrayList<String>();
        if (reservedOnly) {
            retainList.addAll(keywordList1.getReservedList());
            retainList.retainAll(keywordList2.getReservedList());
            list1.addAll(keywordList1.getReservedList());
            list2.addAll(keywordList2.getReservedList());
        } else {
            retainList.addAll(keywordList1.getKeywordList());
            retainList.retainAll(keywordList2.getKeywordList());
            list1.addAll(keywordList1.getKeywordList());
            list2.addAll(keywordList2.getKeywordList());
        }
        list1.removeAll(retainList);
        list2.removeAll(retainList);
        for (int i = 0; i < list2.size(); ++i) {
            list1.add(MINUS + (String)list2.get(i));
        }
        Collections.sort(list1, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                if (!str1.startsWith(keywordChecker.MINUS)) {
                    str1 = keywordChecker.MINUS + str1;
                }
                if (!str2.startsWith(keywordChecker.MINUS)) {
                    str2 = keywordChecker.MINUS + str2;
                }
                return str1.compareToIgnoreCase(str2);
            }
        });
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list1.size(); ++i) {
            buffer.append((String)list1.get(i));
            if (i >= list1.size() - 1) continue;
            buffer.append(COMMA);
        }
        return buffer.toString();
    }

    public static List<String> getAvailableDbVersions(EDbVendor dbvendor) {
        return keywordListFactory.getInstance().getAvailableDbVersions(dbvendor);
    }

    public static boolean containsDbVersion(EDbVendor dbvendor, String dbVersion) {
        return keywordListFactory.getInstance().containsDbVersion(dbvendor, dbVersion);
    }

    public static void main(String[] args) {
        keywordChecker.getAvailableDbVersions(EDbVendor.dbvsybase).size();
        keywordChecker.getKeywordList(EDbVendor.dbvsybase, "15.7", false);
        keywordChecker.getKeywordList(EDbVendor.dbvsybase, "12.5", false);
        long time = System.currentTimeMillis();
        String keywordStr = keywordChecker.getKeywordList(EDbVendor.dbvsybase, "15.7", false);
        String[] keywords = keywordStr.split(COMMA);
        for (int i = 0; i < keywords.length; ++i) {
            boolean flag = keywordChecker.isKeyword(keywords[i].trim(), EDbVendor.dbvsybase, "15.7", false);
            if (flag) continue;
            System.out.println(keywords[i] + "'s status is error");
        }
        keywordChecker.compareKeywordList(EDbVendor.dbvsybase, "15.7", EDbVendor.dbvsybase, "12.5", false);
        System.out.println("Time=" + (System.currentTimeMillis() - time) + "ms");
    }
}

