/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class functionLoader {
    private static Map<EDbVendor, Properties> functionMap = new HashMap<EDbVendor, Properties>();

    functionLoader() {
    }

    private static synchronized void loadFunctionList(EDbVendor vendor) {
        if (vendor != null && !functionMap.containsKey((Object)vendor)) {
            String vendorString = null;
            switch (vendor) {
                case dbvaccess: {
                    vendorString = "access";
                    break;
                }
                case dbvfirebird: {
                    vendorString = "firebird";
                    break;
                }
                case dbvgeneric: {
                    vendorString = "generic";
                    break;
                }
                case dbvinformix: {
                    vendorString = "informix";
                    break;
                }
                case dbvhive: {
                    vendorString = "hive";
                    break;
                }
                case dbvimpala: {
                    vendorString = "impala";
                    break;
                }
                case dbvsnowflake: {
                    vendorString = "snowflake";
                    break;
                }
                case dbvredshift: {
                    vendorString = "redshift";
                    break;
                }
                case dbvgreenplum: {
                    vendorString = "greenplum";
                    break;
                }
                case dbvmdx: {
                    vendorString = "mdx";
                    break;
                }
                case dbvnetezza: {
                    vendorString = "netezza";
                    break;
                }
                case dbvmssql: {
                    vendorString = "mssql";
                    break;
                }
                case dbvoracle: {
                    vendorString = "oracle";
                    break;
                }
                case dbvmysql: {
                    vendorString = "mysql";
                    break;
                }
                case dbvdb2: {
                    vendorString = "db2";
                    break;
                }
                case dbvpostgresql: {
                    vendorString = "postgresql";
                    break;
                }
                case dbvsybase: {
                    vendorString = "sybase";
                    break;
                }
                case dbvteradata: {
                    vendorString = "teradata";
                    break;
                }
                case dbvansi: {
                    vendorString = "ansi";
                    break;
                }
                case dbvodbc: {
                    vendorString = "odbc";
                    break;
                }
                case dbvbigquery: {
                    vendorString = "bigquery";
                    break;
                }
                case dbvcouchbase: {
                    vendorString = "couchbase";
                    break;
                }
                case dbvhana: {
                    vendorString = "hana";
                    break;
                }
                case dbvvertica: {
                    vendorString = "vertica";
                }
            }
            InputStream is = functionLoader.class.getResourceAsStream("/gudusoft/gsqlparser/util/" + vendorString + "_function.properties");
            if (is != null) {
                Properties properties = new Properties();
                try {
                    properties.load(is);
                    functionMap.put(vendor, properties);
                    return;
                }
                catch (IOException e) {
                    Logger.getLogger(functionLoader.class.getName()).log(Level.WARNING, "Load " + vendorString + ".properties" + " failed.", e);
                }
            } else {
                Logger.getLogger(functionLoader.class.getName()).log(Level.WARNING, "Doesn't implement " + (Object)((Object)vendor));
            }
            functionMap.put(vendor, null);
        }
    }

    public static Properties getFunctionList(EDbVendor vendor) {
        functionLoader.loadFunctionList(vendor);
        return functionMap.get((Object)vendor);
    }
}

