/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.util.functionList;
import gudusoft.gsqlparser.util.functionLoader;
import gudusoft.gsqlparser.util.functionMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

class functionListFactory {
    private HashMap<EDbVendor, functionMap> functionListMap = new HashMap();
    private Object object = new Object();

    public static final functionListFactory getInstance() {
        return SingletonContainer.instance;
    }

    public functionList getBuiltInFunctionList(EDbVendor dbvendor, String dbVersion) {
        this.loadBuiltInFunctionList(dbvendor);
        functionMap function = this.functionListMap.get((Object)dbvendor);
        if (function != null) {
            return function.getBuiltInFunctionList(dbVersion);
        }
        return null;
    }

    public List<String> getAvailableDbVersions(EDbVendor dbvendor) {
        this.loadBuiltInFunctionList(dbvendor);
        functionMap Function2 = this.functionListMap.get((Object)dbvendor);
        if (Function2 != null) {
            return Function2.getDbVersions();
        }
        return null;
    }

    public boolean containsDbVersion(EDbVendor dbvendor, String dbVersion) {
        this.loadBuiltInFunctionList(dbvendor);
        functionMap Function2 = this.functionListMap.get((Object)dbvendor);
        if (Function2 != null && dbVersion != null) {
            return Function2.containsVersion(dbVersion);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBuiltInFunctionList(EDbVendor dbvendor) {
        if (this.functionListMap.containsKey((Object)dbvendor)) {
            return;
        }
        Object object = this.object;
        synchronized (object) {
            if (this.functionListMap.containsKey((Object)dbvendor)) {
                return;
            }
            functionMap functionMap2 = new functionMap();
            Properties properties = functionLoader.getFunctionList(dbvendor);
            if (properties != null) {
                String[] keys = properties.keySet().toArray(new String[0]);
                ArrayList<String> versions = new ArrayList<String>();
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i].toUpperCase();
                    if (versions.contains(key)) continue;
                    versions.add(key);
                }
                for (String version : versions) {
                    functionList functionList2 = new functionList(dbvendor);
                    String reservedKey = version;
                    if (properties.containsKey(reservedKey)) {
                        String[] functions = properties.getProperty(reservedKey).split(",");
                        for (int i = 0; i < functions.length; ++i) {
                            String function = functions[i].trim().toUpperCase();
                            if (functionList2.getBuiltInFunctionList().contains(function)) continue;
                            functionList2.getBuiltInFunctionList().add(function);
                        }
                        Collections.sort(functionList2.getBuiltInFunctionList());
                    }
                    functionMap2.setBuiltInFunctionList(version, functionList2);
                }
            }
            this.functionListMap.put(dbvendor, functionMap2);
        }
    }

    private functionListFactory() {
    }

    private static class SingletonContainer {
        private static final functionListFactory instance = new functionListFactory();

        private SingletonContainer() {
        }
    }
}

