/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.util;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.util.functionList;
import gudusoft.gsqlparser.util.functionListFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class functionChecker {
    private static final String COMMA = ",";
    private static final String MINUS = "-";

    private functionChecker() {
    }

    public static boolean isBuiltInFunction(String inputString, EDbVendor dbvendor, String dbVersion) {
        if (inputString == null || inputString.trim().equals("")) {
            return false;
        }
        String function = inputString.toUpperCase();
        functionList functionList2 = functionListFactory.getInstance().getBuiltInFunctionList(dbvendor, dbVersion);
        if (functionList2 == null) {
            throw new IllegalArgumentException("Can't get available built-in function list");
        }
        return functionList2.getBuiltInFunctionList().contains(function);
    }

    public static String getBuiltInFunctionList(EDbVendor dbvendor, String dbVersion) {
        functionList functionList2 = functionListFactory.getInstance().getBuiltInFunctionList(dbvendor, dbVersion);
        if (functionList2 == null) {
            throw new IllegalArgumentException("Can't get available built-in function list");
        }
        List<String> functions = functionList2.getBuiltInFunctionList();
        if (functions != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < functions.size(); ++i) {
                if (i < functions.size() - 1) {
                    buffer.append(functions.get(i)).append(COMMA);
                    continue;
                }
                buffer.append(functions.get(i));
            }
            return buffer.toString();
        }
        return null;
    }

    public static String compareBuiltInFunctionList(EDbVendor dbvendor1, String dbVersion1, EDbVendor dbvendor2, String dbVersion2) {
        functionList functionList1 = functionListFactory.getInstance().getBuiltInFunctionList(dbvendor1, dbVersion1);
        functionList functionList2 = functionListFactory.getInstance().getBuiltInFunctionList(dbvendor2, dbVersion2);
        if (functionList1 == null || functionList2 == null) {
            throw new IllegalArgumentException("Can't get available built-in function list");
        }
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        ArrayList<String> retainList = new ArrayList<String>();
        retainList.addAll(functionList1.getBuiltInFunctionList());
        retainList.retainAll(functionList2.getBuiltInFunctionList());
        list1.addAll(functionList1.getBuiltInFunctionList());
        list2.addAll(functionList2.getBuiltInFunctionList());
        list1.removeAll(retainList);
        list2.removeAll(retainList);
        for (int i = 0; i < list2.size(); ++i) {
            list1.add(MINUS + (String)list2.get(i));
        }
        Collections.sort(list1, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                if (!str1.startsWith(functionChecker.MINUS)) {
                    str1 = functionChecker.MINUS + str1;
                }
                if (!str2.startsWith(functionChecker.MINUS)) {
                    str2 = functionChecker.MINUS + str2;
                }
                return str1.compareToIgnoreCase(str2);
            }
        });
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list1.size(); ++i) {
            buffer.append((String)list1.get(i));
            if (i >= list1.size() - 1) continue;
            buffer.append(COMMA);
        }
        return buffer.toString();
    }

    public static List<String> getAvailableDbVersions(EDbVendor dbvendor) {
        return functionListFactory.getInstance().getAvailableDbVersions(dbvendor);
    }

    public static boolean containsDbVersion(EDbVendor dbvendor, String dbVersion) {
        return functionListFactory.getInstance().containsDbVersion(dbvendor, dbVersion);
    }

    public static void main(String[] args) {
        EDbVendor db = EDbVendor.dbvoracle;
        int i = functionChecker.getAvailableDbVersions(db).size();
        for (int k = 0; k < i; ++k) {
            System.out.println(functionChecker.getAvailableDbVersions(db).get(k));
        }
    }
}

