/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.vertica;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TCreateFunctionSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSymbolTableItem;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.stmt.TCommonStoredProcedureSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlReturn;

public class TVerticaCreateFunction
extends TCommonStoredProcedureSqlStatement {
    private TObjectName functionName = null;
    private TTypeName returnDataType = null;
    private TConstant procedureLanguage;
    private TMssqlReturn returnStmt = null;

    public TVerticaCreateFunction(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcreatefunction;
    }

    public TConstant getProcedureLanguage() {
        return this.procedureLanguage;
    }

    public TMssqlReturn getReturnStmt() {
        return this.returnStmt;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        int i;
        if (this.rootNode == null) {
            return -1;
        }
        TCreateFunctionSqlNode createFunctionNode = (TCreateFunctionSqlNode)this.rootNode;
        if (super.doParseStatement(psql) != 0) {
            return -1;
        }
        this.functionName = createFunctionNode.getFunctionName();
        this.procedureLanguage = createFunctionNode.getProcedureLanguage();
        this.setParameterDeclarations(createFunctionNode.getParameters());
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(9, (TCustomSqlStatement)this, (TParseTreeNode)this.getParameterDeclarations().getParameterDeclarationItem(i)));
            }
        }
        this.returnStmt = new TMssqlReturn(this.dbvendor);
        this.returnStmt.rootNode = createFunctionNode.getReturnSqlNode();
        this.returnStmt.doParseStatement(this);
        this.getBodyStatements().add(this.returnStmt);
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        return 0;
    }

    public TObjectName getFunctionName() {
        return this.functionName;
    }

    public TTypeName getReturnDataType() {
        return this.returnDataType;
    }

    @Override
    public TObjectName getStoredProcedureName() {
        return this.functionName;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getParameterDeclarations() != null) {
            this.getParameterDeclarations().accept(v);
        }
        v.postVisit(this);
    }

    public void setFunctionName(TObjectName functionName) {
        this.functionName = functionName;
    }

    public void setReturnDataType(TTypeName returnDataType) {
        this.returnDataType = returnDataType;
    }

    public void setProcedureLanguage(TConstant procedureLanguage) {
        this.procedureLanguage = procedureLanguage;
    }
}

