/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.teradata;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TCollectStatisticsSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.teradata.TCollectColumnIndex;

public class TTeradataCollectStatistics
extends TCustomSqlStatement {
    private TTable table = null;
    private TObjectName tableName = null;
    private TPTNodeList<TCollectColumnIndex> columnIndexList;

    public TTeradataCollectStatistics(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstteradatacollectstatistics;
    }

    public TObjectName getTableName() {
        return this.tableName;
    }

    public TPTNodeList<TCollectColumnIndex> getColumnIndexList() {
        return this.columnIndexList;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TCollectStatisticsSqlNode collectStatisticsSqlNode = (TCollectStatisticsSqlNode)this.rootNode;
        this.tableName = collectStatisticsSqlNode.getTableName();
        this.table = new TTable();
        this.table.setTableName(this.tableName);
        this.table.setTableType(ETableSource.objectname);
        this.tables.addTable(this.table);
        this.columnIndexList = collectStatisticsSqlNode.getColumnIndexList();
        if (this.columnIndexList != null) {
            this.columnIndexList.doParse(this, ESqlClause.index);
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.columnIndexList != null) {
            this.columnIndexList.accept(v);
        }
        v.postVisit(this);
    }

    public void setTable(TTable table) {
        this.table = table;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
    }

    public void setColumnIndexList(TPTNodeList<TCollectColumnIndex> columnIndexList) {
        this.columnIndexList = columnIndexList;
    }
}

