/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.postgresql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TStackFrame;
import gudusoft.gsqlparser.TSymbolVariable;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TCreateFunctionSqlNode;
import gudusoft.gsqlparser.nodes.TDummy;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSymbolTableItem;
import gudusoft.gsqlparser.nodes.TTableElementList;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.stmt.TCommonBlock;
import gudusoft.gsqlparser.stmt.TCommonStoredProcedureSqlStatement;

public class TPostgresqlCreateFunction
extends TCommonStoredProcedureSqlStatement {
    private TObjectName outerLabelName = null;
    private TObjectName functionName = null;
    private TTypeName returnDataType = null;
    private TConstant objfile;
    private TConstant linkSymbol;
    private TConstant procedureLanguage;
    private int returnMode = 1;
    private TTableElementList returnTableDefinitions = null;

    public TConstant getProcedureLanguage() {
        return this.procedureLanguage;
    }

    public TObjectName getOuterLabelName() {
        return this.outerLabelName;
    }

    public TConstant getLinkSymbol() {
        return this.linkSymbol;
    }

    public TConstant getObjfile() {
        return this.objfile;
    }

    public int getReturnMode() {
        return this.returnMode;
    }

    public TTableElementList getReturnTableDefinitions() {
        return this.returnTableDefinitions;
    }

    public TPostgresqlCreateFunction(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstpostgresqlCreateFunction;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        TCreateFunctionSqlNode createFunctionNode = (TCreateFunctionSqlNode)this.rootNode;
        if (super.doParseStatement(psql) != 0) {
            return -1;
        }
        TStackFrame currentStackFrame = new TStackFrame(this.stmtScope);
        currentStackFrame.pushStack(this.getFrameStack());
        this.functionName = createFunctionNode.getFunctionName();
        this.procedureLanguage = createFunctionNode.getProcedureLanguage();
        this.outerLabelName = createFunctionNode.getLabelName();
        this.objfile = createFunctionNode.getObjfile();
        this.linkSymbol = createFunctionNode.getLinkSymbol();
        if (createFunctionNode.getReturnDataType() != null) {
            this.returnMode = 1;
            this.returnDataType = createFunctionNode.getReturnDataType();
        } else if (createFunctionNode.getReturnTable() != null) {
            TDummy dmy = createFunctionNode.getReturnTable();
            this.returnMode = 2;
            this.returnTableDefinitions = (TTableElementList)dmy.list1;
            this.returnTableDefinitions.doParse(this, ESqlClause.unknown);
        }
        this.setParameterDeclarations(createFunctionNode.getParameters());
        if (this.getParameterDeclarations() != null) {
            for (int i = 0; i < this.getParameterDeclarations().size(); ++i) {
                TParameterDeclaration parameterDeclaration = this.getParameterDeclarations().getParameterDeclarationItem(i);
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(9, (TCustomSqlStatement)this, (TParseTreeNode)parameterDeclaration));
                if (parameterDeclaration.getParameterName() == null) continue;
                this.stmtScope.addSymbol(new TSymbolVariable(parameterDeclaration.getParameterName(), parameterDeclaration, this.functionName));
            }
        }
        if (createFunctionNode.getDeclareStmts() != null) {
            createFunctionNode.getDeclareStmts().doParse(this, ESqlClause.unknown);
            for (int i = 0; i < createFunctionNode.getDeclareStmts().size(); ++i) {
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(10, (TCustomSqlStatement)this, (TParseTreeNode)createFunctionNode.getDeclareStmts().getStatementSqlNode(i).getStmt()));
                this.getDeclareStatements().add(createFunctionNode.getDeclareStmts().getStatementSqlNode(i).getStmt());
            }
        }
        if (createFunctionNode.getStmts() != null) {
            createFunctionNode.getStmts().doParse(this, ESqlClause.unknown);
            for (int i = 0; i < createFunctionNode.getStmts().size(); ++i) {
                this.getBodyStatements().add(createFunctionNode.getStmts().getStatementSqlNode(i).getStmt());
            }
        }
        if (createFunctionNode.getExceptionClause() != null) {
            createFunctionNode.getExceptionClause().doParse(this, ESqlClause.unknown);
            this.setExceptionClause(createFunctionNode.getExceptionClause());
        }
        if (createFunctionNode.getDeclareStmts() != null) {
            for (int i = 0; i < createFunctionNode.getDeclareStmts().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        if (createFunctionNode.getFunctionBody() != null && this.getProcedureLanguage().toString() != null && (this.getProcedureLanguage().toString().equalsIgnoreCase("sql") || this.getProcedureLanguage().toString().equalsIgnoreCase("plpgsql"))) {
            String bodyStr = createFunctionNode.getFunctionBody().getStartToken().getQuotedString();
            if (createFunctionNode.getFunctionBody().getStartToken().toString().startsWith("'")) {
                bodyStr = bodyStr.replaceAll("''", "'");
            }
            String prefixStr = bodyStr.trim().substring(0, 9).toLowerCase();
            String suffixStr = bodyStr.trim().length() <= 7 ? bodyStr.trim() : bodyStr.trim().substring(bodyStr.trim().length() - 7);
            boolean isSQLBlock = true;
            TGSqlParser newParser = new TGSqlParser(EDbVendor.dbvpostgresql);
            if (prefixStr.startsWith("declare") || prefixStr.startsWith("begin") || prefixStr.startsWith("<<") || suffixStr.toLowerCase().endsWith("end")) {
                newParser.sqltext = "plpgsql_function_delimiter " + TBaseType.stringBlock((int)createFunctionNode.getFunctionBody().getStartToken().lineNo - 1, (int)createFunctionNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
            } else {
                newParser.sqltext = "\n" + TBaseType.stringBlock((int)createFunctionNode.getFunctionBody().getStartToken().lineNo - 1, (int)createFunctionNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
                isSQLBlock = false;
            }
            newParser.setFrameStack(this.getFrameStack());
            int iRet = newParser.parse();
            if (iRet == 0 && newParser.getSqlstatements().size() > 0) {
                if (isSQLBlock) {
                    int i;
                    TCommonBlock commonBlock = (TCommonBlock)newParser.getSqlstatements().get(0);
                    this.setOuterLabelName(commonBlock.getLabelName());
                    for (i = 0; i < commonBlock.getDeclareStatements().size(); ++i) {
                        this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(10, (TCustomSqlStatement)this, (TParseTreeNode)commonBlock.getDeclareStatements().get(i)));
                        this.getDeclareStatements().add(commonBlock.getDeclareStatements().get(i));
                    }
                    for (i = 0; i < commonBlock.getBodyStatements().size(); ++i) {
                        commonBlock.getBodyStatements().get(i).setAlreadyAddToParent(false);
                        commonBlock.getBodyStatements().get(i).setParentStmt(this);
                        this.getBodyStatements().add(commonBlock.getBodyStatements().get(i));
                    }
                    if (commonBlock.getExceptionClause() != null) {
                        this.setExceptionClause(commonBlock.getExceptionClause());
                    }
                    for (i = 0; i < commonBlock.getDeclareStatements().size(); ++i) {
                        this.getTopStatement().getSymbolTable().pop();
                    }
                } else {
                    this.getBodyStatements().add(newParser.getSqlstatements().get(0));
                }
            } else {
                for (int j = 0; j < newParser.getErrorCount(); ++j) {
                    this.parseerrormessagehandle(newParser.getSyntaxErrors().get(j));
                }
            }
        }
        if (this.getParameterDeclarations() != null) {
            for (int i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        currentStackFrame.popStack(this.getFrameStack());
        return 0;
    }

    public TObjectName getFunctionName() {
        return this.functionName;
    }

    public TTypeName getReturnDataType() {
        return this.returnDataType;
    }

    @Override
    public TObjectName getStoredProcedureName() {
        return this.functionName;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getParameterDeclarations() != null) {
            this.getParameterDeclarations().accept(v);
        }
        if (this.getDeclareStatements().size() > 0) {
            this.getDeclareStatements().accept(v);
        }
        if (this.getBodyStatements().size() > 0) {
            this.getBodyStatements().accept(v);
        }
        if (this.getExceptionClause() != null) {
            this.getExceptionClause().accept(v);
        }
        v.postVisit(this);
    }

    public void setOuterLabelName(TObjectName outerLabelName) {
        this.outerLabelName = outerLabelName;
    }

    public void setFunctionName(TObjectName functionName) {
        this.functionName = functionName;
    }

    public void setReturnDataType(TTypeName returnDataType) {
        this.returnDataType = returnDataType;
    }

    public void setObjfile(TConstant objfile) {
        this.objfile = objfile;
    }

    public void setLinkSymbol(TConstant linkSymbol) {
        this.linkSymbol = linkSymbol;
    }

    public void setReturnMode(int returnMode) {
        this.returnMode = returnMode;
    }

    public void setReturnTableDefinitions(TTableElementList returnTableDefinitions) {
        this.returnTableDefinitions = returnTableDefinitions;
    }

    public void setProcedureLanguage(TConstant procedureLanguage) {
        this.procedureLanguage = procedureLanguage;
    }
}

