/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.postgresql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.postgresql.TMoveSqlNode;

public class TMoveStmt
extends TCustomSqlStatement {
    private TObjectName cursorName;
    private TConstant moveCount;

    public TMoveStmt() {
        this(EDbVendor.dbvpostgresql);
    }

    public TMoveStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstpostgresqlMove;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TMoveSqlNode sqlNode = (TMoveSqlNode)this.rootNode;
        this.cursorName = sqlNode.getCursorName();
        this.moveCount = sqlNode.getMoveCount();
        return 0;
    }

    public TConstant getMoveCount() {
        return this.moveCount;
    }

    public TObjectName getCursorName() {
        return this.cursorName;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setCursorName(TObjectName cursorName) {
        this.cursorName = cursorName;
    }

    public void setMoveCount(TConstant moveCount) {
        this.moveCount = moveCount;
    }
}

