/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.mysql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.mysql.TMySQLPrepareSqlNode;

public class TMySQLPrepareStmt
extends TCustomSqlStatement {
    private TCustomSqlStatement preparableStmt;
    private TObjectName stmtName;
    private String preparableStmtStr = "";
    TGSqlParser parser;

    public TMySQLPrepareStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstmysqlprepare;
    }

    public TCustomSqlStatement getPreparableStmt() {
        return this.preparableStmt;
    }

    public String getPreparableStmtStr() {
        return this.preparableStmtStr;
    }

    public TObjectName getStmtName() {
        return this.stmtName;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TMySQLPrepareSqlNode sqlNode = (TMySQLPrepareSqlNode)this.rootNode;
        this.stmtName = sqlNode.getStmtName();
        this.preparableStmtStr = "";
        if (sqlNode.getPreparableStmt().startsWith("'")) {
            this.preparableStmtStr = sqlNode.getPreparableStmt().toString().replace("'", "");
        } else if (sqlNode.getPreparableStmt().startsWith("\"")) {
            this.preparableStmtStr = sqlNode.getPreparableStmt().toString().replace("\"", "");
        }
        if (this.preparableStmtStr.length() > 0) {
            this.parser = new TGSqlParser(EDbVendor.dbvmysql);
            this.parser.sqltext = this.preparableStmtStr;
            if (this.parser.parse() == 0) {
                this.preparableStmt = this.parser.sqlstatements.get(0);
            }
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.preparableStmt != null) {
            this.preparableStmt.accept(v);
        }
        v.postVisit(this);
    }

    public void setPreparableStmt(TCustomSqlStatement preparableStmt) {
        this.preparableStmt = preparableStmt;
    }

    public void setStmtName(TObjectName stmtName) {
        this.stmtName = stmtName;
    }

    public void setPreparableStmtStr(String preparableStmtStr) {
        this.preparableStmtStr = preparableStmtStr;
    }
}

