/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.mssql;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EErrorType;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETokenType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSourceTokenList;
import gudusoft.gsqlparser.TSyntaxError;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TExecParameterList;
import gudusoft.gsqlparser.nodes.TExecuteSqlNode;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.mssql.TExecuteOption;

public class TMssqlExecute
extends TCustomSqlStatement {
    private TObjectName moduleName = null;
    private TObjectName returnStatus = null;
    private TExecParameterList parameters = null;
    private TExpressionList stringValues = null;
    private int execType = 0;
    private TExecuteOption executeOption;

    public TMssqlExecute(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstmssqlexec;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    public TObjectName getModuleName() {
        return this.moduleName;
    }

    public TExecParameterList getParameters() {
        return this.parameters;
    }

    public TObjectName getReturnStatus() {
        return this.returnStatus;
    }

    public TExpressionList getStringValues() {
        return this.stringValues;
    }

    public int getExecType() {
        return this.execType;
    }

    private boolean isValidProcedureCall(TSourceTokenList stList, TSyntaxError err) {
        boolean ret = false;
        if (stList.size() <= 1) {
            return false;
        }
        TSourceToken st = stList.get(0);
        if (st.tokencode == 314) {
            TSourceToken nextst = stList.nextsolidtoken(st, 1, false);
            err.hint = "Unknown object type in drop statement";
            if (nextst != null) {
                err.tokentext = nextst.toString();
                err.lineNo = nextst.lineNo;
                err.columnNo = nextst.columnNo;
            }
            return false;
        }
        if (stList.get((int)1).tokentype == ETokenType.ttperiod) {
            return true;
        }
        if (st.toString().toLowerCase().startsWith("sp")) {
            return true;
        }
        if (st.toString().toLowerCase().startsWith("select")) {
            return false;
        }
        if (st.toString().toLowerCase().startsWith("del")) {
            return false;
        }
        if (st.toString().toLowerCase().startsWith("update")) {
            return false;
        }
        if (st.toString().toLowerCase().startsWith("insert")) {
            return false;
        }
        if (st.toString().toLowerCase().startsWith("create")) {
            return false;
        }
        return ret;
    }

    public TExecuteOption getExecuteOption() {
        return this.executeOption;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        if (!(this.rootNode instanceof TExecuteSqlNode)) {
            TSourceToken st1;
            TSyntaxError err;
            if (this.sourcetokenlist.size() > 0 && !this.isValidProcedureCall(this.sourcetokenlist, err = new TSyntaxError((st1 = this.sourcetokenlist.get(0)).toString(), st1.lineNo, st1.columnNo, "syntax error", EErrorType.sperror, 10111))) {
                this.parseerrormessagehandle(err);
            }
            return -1;
        }
        TExecuteSqlNode node = (TExecuteSqlNode)this.rootNode;
        this.execType = node.getExecType();
        this.executeOption = node.getExecuteOption();
        super.doParseStatement(psql);
        if (node.getExecType() == 0) {
            this.moduleName = node.getModuleName();
            this.parameters = node.getParameters();
            this.returnStatus = node.getReturnStatus();
        } else if (node.getExecType() == 1) {
            this.stringValues = node.getStringValues();
        } else if (node.getExecType() == 3 && this.sourcetokenlist.size() > 0) {
            TSourceToken st1 = this.sourcetokenlist.get(0);
            String errMsg = "syntax error";
            TSourceToken errToken = st1;
            TSyntaxError err = new TSyntaxError(st1.toString(), st1.lineNo, st1.columnNo, "syntax error", EErrorType.sperror, 10111);
            if (!this.isValidProcedureCall(this.sourcetokenlist, err)) {
                this.parseerrormessagehandle(err);
            }
            this.moduleName = new TObjectName();
            this.moduleName.setGsqlparser(this.getGsqlparser());
            int j = 0;
            for (int i = 0; i < this.sourcetokenlist.size() && this.sourcetokenlist.get((int)i).tokentype != ETokenType.ttwhitespace && this.sourcetokenlist.get((int)i).tokentype != ETokenType.ttreturn && this.sourcetokenlist.get((int)i).tokentype != ETokenType.ttsemicolon; ++i) {
                ++j;
            }
            switch (j) {
                case 1: {
                    this.moduleName.init(this.sourcetokenlist.get(0));
                    break;
                }
                case 3: {
                    this.moduleName.init(this.sourcetokenlist.get(0), this.sourcetokenlist.get(2));
                    break;
                }
                case 5: {
                    this.moduleName.init(this.sourcetokenlist.get(0), this.sourcetokenlist.get(2), this.sourcetokenlist.get(4));
                    break;
                }
                case 7: {
                    this.moduleName.init(this.sourcetokenlist.get(0), (Object)this.sourcetokenlist.get(2), (Object)this.sourcetokenlist.get(4), (Object)this.sourcetokenlist.get(6));
                    break;
                }
                default: {
                    this.moduleName = null;
                }
            }
            if (this.moduleName != null) {
                this.moduleName.setObjectType(12);
            }
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setModuleName(TObjectName moduleName) {
        this.moduleName = moduleName;
    }

    public void setReturnStatus(TObjectName returnStatus) {
        this.returnStatus = returnStatus;
    }

    public void setParameters(TExecParameterList parameters) {
        this.parameters = parameters;
    }

    public void setStringValues(TExpressionList stringValues) {
        this.stringValues = stringValues;
    }

    public void setExecType(int execType) {
        this.execType = execType;
    }
}

