/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.hive;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.hive.THiveGrantSqlNode;
import gudusoft.gsqlparser.nodes.hive.THivePrincipalName;
import gudusoft.gsqlparser.nodes.hive.THivePrivilegeDef;

public class THiveRevoke
extends TCustomSqlStatement {
    private TPTNodeList<THivePrincipalName> principals;
    private TPTNodeList<THivePrivilegeDef> privilegeList;
    private TTable table;
    private TSourceToken tableToken;

    public THiveRevoke(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.ssthiveRevoke;
    }

    public TPTNodeList<THivePrincipalName> getPrincipals() {
        return this.principals;
    }

    public TPTNodeList<THivePrivilegeDef> getPrivilegeList() {
        return this.privilegeList;
    }

    public TTable getTable() {
        return this.table;
    }

    public TSourceToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        THiveGrantSqlNode node = (THiveGrantSqlNode)this.rootNode;
        this.table = this.analyzeFromTable(node.getFromTable(), true);
        this.principals = node.getPrincipals();
        this.privilegeList = node.getPrivilegeList();
        this.tableToken = node.getTableToken();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.principals != null) {
            this.principals.accept(v);
        }
        if (this.privilegeList != null) {
            this.privilegeList.accept(v);
        }
        v.postVisit(this);
    }

    public void setPrincipals(TPTNodeList<THivePrincipalName> principals) {
        this.principals = principals;
    }

    public void setPrivilegeList(TPTNodeList<THivePrivilegeDef> privilegeList) {
        this.privilegeList = privilegeList;
    }

    public void setTable(TTable table) {
        this.table = table;
    }
}

