/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.hive;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.hive.THiveLoadSqlNode;

public class THiveLoad
extends TCustomSqlStatement {
    private boolean islocal = false;
    private boolean isoverwrite = false;
    private TObjectName path;
    private TTable table;

    public THiveLoad(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.ssthiveLoad;
    }

    public boolean isIslocal() {
        return this.islocal;
    }

    public boolean isIsoverwrite() {
        return this.isoverwrite;
    }

    public TObjectName getPath() {
        return this.path;
    }

    public TTable getTable() {
        return this.table;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        THiveLoadSqlNode node = (THiveLoadSqlNode)this.rootNode;
        this.islocal = node.isIslocal();
        this.isoverwrite = node.isIsoverwrite();
        this.path = node.getPath();
        this.table = this.analyzeFromTable(node.getFromTable(), true);
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setIslocal(boolean islocal) {
        this.islocal = islocal;
    }

    public void setIsoverwrite(boolean isoverwrite) {
        this.isoverwrite = isoverwrite;
    }

    public void setPath(TObjectName path) {
        this.path = path;
    }

    public void setTable(TTable table) {
        this.table = table;
    }
}

