/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt.hive;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.hive.THiveImportSqlNode;

public class THiveImportTable
extends TCustomSqlStatement {
    private boolean external = false;
    private TTable table;
    private TObjectName path;
    private TObjectName tableLocation;

    public THiveImportTable(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.ssthiveImportTable;
    }

    public boolean isExternal() {
        return this.external;
    }

    public TObjectName getPath() {
        return this.path;
    }

    public TTable getTable() {
        return this.table;
    }

    public TObjectName getTableLocation() {
        return this.tableLocation;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        THiveImportSqlNode node = (THiveImportSqlNode)this.rootNode;
        this.external = node.isExternal();
        this.path = node.getPath();
        this.tableLocation = node.getTableLocation();
        if (node.getFromTable() != null) {
            this.table = this.analyzeFromTable(node.getFromTable(), true);
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setTable(TTable table) {
        this.table = table;
    }

    public void setPath(TObjectName path) {
        this.path = path;
    }

    public void setTableLocation(TObjectName tableLocation) {
        this.tableLocation = tableLocation;
    }
}

