/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TUpsertSqlNode;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class TUpsertStmt
extends TCustomSqlStatement {
    private TMultiTargetList values = null;
    private TSelectSqlStatement subQuery = null;

    public TUpsertStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstupsert;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TUpsertSqlNode upsertSqlNode = (TUpsertSqlNode)this.rootNode;
        TTable lcTable = this.analyzeFromTable(upsertSqlNode.getTargetTable(), true);
        lcTable.setEffectType(ETableEffectType.tetUpsert);
        this.setTargetTable(lcTable);
        if (upsertSqlNode.getValues() != null) {
            upsertSqlNode.getValues().doParse(this, ESqlClause.insertValues);
            this.values = upsertSqlNode.getValues();
        } else if (upsertSqlNode.getSubQueryNode() != null) {
            this.subQuery = new TSelectSqlStatement(this.dbvendor);
            this.subQuery.rootNode = upsertSqlNode.getSubQueryNode();
            this.subQuery.doParseStatement(this);
        }
        if (upsertSqlNode.getReturningClause() != null) {
            upsertSqlNode.getReturningClause().doParse(this, ESqlClause.returning);
            this.setReturningClause(upsertSqlNode.getReturningClause());
        }
        this.setWhereClause(upsertSqlNode.getWhereClause());
        return 0;
    }

    public TMultiTargetList getValues() {
        return this.values;
    }

    public TSelectSqlStatement getSubQuery() {
        return this.subQuery;
    }
}

