/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TLimitClause;
import gudusoft.gsqlparser.nodes.TOrderBy;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TUpdateSqlNode;
import gudusoft.gsqlparser.nodes.couchbase.TUseKeyIndex;
import gudusoft.gsqlparser.nodes.mssql.TOptionClause;
import gudusoft.gsqlparser.nodes.oracle.TErrorLoggingClause;
import gudusoft.gsqlparser.stmt.TInsertSqlStatement;

public class TUpdateSqlStatement
extends TCustomSqlStatement {
    private TInsertSqlStatement insertSqlStatement = null;
    private TErrorLoggingClause errorLoggingClause;
    private TOptionClause optionClause;
    private TSourceToken updateToken = null;
    private TJoinList referenceJoins = null;
    private TOrderBy orderByClause = null;
    private TLimitClause limitClause = null;
    private TUseKeyIndex useKeyIndex;
    private TResultColumnList unSetTerms;

    public TInsertSqlStatement getInsertSqlStatement() {
        return this.insertSqlStatement;
    }

    public TErrorLoggingClause getErrorLoggingClause() {
        return this.errorLoggingClause;
    }

    public TOptionClause getOptionClause() {
        return this.optionClause;
    }

    public void setUpdateToken(TSourceToken updateToken) {
        this.updateToken = updateToken;
    }

    public TSourceToken getUpdateToken() {
        return this.updateToken;
    }

    public TJoinList getReferenceJoins() {
        if (this.referenceJoins == null) {
            this.referenceJoins = new TJoinList();
        }
        return this.referenceJoins;
    }

    public TLimitClause getLimitClause() {
        return this.limitClause;
    }

    public TOrderBy getOrderByClause() {
        return this.orderByClause;
    }

    public TUpdateSqlStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstupdate;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        TTable lcTable;
        TJoin lcJoin;
        if (this.rootNode == null) {
            return -1;
        }
        TUpdateSqlNode updateNode = (TUpdateSqlNode)this.rootNode;
        if (this.sourcetokenlist.size() == 0) {
            this.setStartToken(updateNode.getStartToken());
            this.setEndToken(updateNode.getEndToken());
        }
        super.doParseStatement(psql);
        this.updateToken = updateNode.getUpdateToken();
        if (updateNode.cteList != null) {
            this.setCteList(updateNode.cteList);
            this.getCteList().doParse(this, ESqlClause.cte);
        }
        if (updateNode.getTopClause() != null) {
            updateNode.getTopClause().doParse(this, ESqlClause.top);
            this.setTopClause(updateNode.getTopClause());
        }
        if (updateNode.getSourceTableList() != null) {
            TFromTable lcFromTable = null;
            lcJoin = null;
            for (int i = 0; i < updateNode.getSourceTableList().size(); ++i) {
                lcFromTable = updateNode.getSourceTableList().getFromTable(i);
                if (lcFromTable.getFromtableType() != ETableSource.join) {
                    lcJoin = new TJoin();
                    lcTable = this.analyzeFromTable(lcFromTable, true);
                    lcTable.setEffectType(ETableEffectType.tetSelect);
                    lcJoin.setTable(lcTable);
                } else {
                    lcJoin = this.analyzeJoin(lcFromTable.getJoinExpr(), null, true);
                    lcJoin.doParse(this, ESqlClause.join);
                }
                this.joins.addJoin(lcJoin);
            }
        }
        if (updateNode.getTargetTable().getFromtableType() != ETableSource.join) {
            boolean isTableAlias = false;
            TTable lcLinkTable = null;
            if (this.getJoins().size() > 0) {
                for (int j = 0; !(j >= this.getJoins().size() || (lcLinkTable = this.getJoins().getJoin(j).getTable()) != null && lcLinkTable.getAliasClause() != null && (isTableAlias = updateNode.getTargetTable().toString().equalsIgnoreCase(lcLinkTable.getAliasName()))); ++j) {
                }
            }
            TTable lcTable2 = this.analyzeFromTable(updateNode.getTargetTable(), false);
            lcTable2.setEffectType(ETableEffectType.tetUpdate);
            if (isTableAlias) {
                lcTable2.setLinkTable(lcLinkTable);
            } else {
                this.tables.insertElementAt(lcTable2, 0);
            }
            this.setTargetTable(lcTable2);
        } else {
            TJoin lcJoin1 = this.analyzeJoin(updateNode.getTargetTable().getJoinExpr(), null, true);
            lcJoin1.doParse(this, ESqlClause.join);
            this.setTargetTable(lcJoin1.getTable());
            this.joins.addJoin(lcJoin1);
        }
        if (updateNode.getUseKeyIndex() != null) {
            this.setUseKeyIndex(updateNode.getUseKeyIndex());
            this.getUseKeyIndex().doParse(this, ESqlClause.unknown);
        }
        if (updateNode.getOutputClause() != null) {
            updateNode.getOutputClause().doParse(this, ESqlClause.output);
            this.setOutputClause(updateNode.getOutputClause());
        }
        this.setResultColumnList(updateNode.getResultColumnList());
        if (this.getResultColumnList() != null) {
            this.getResultColumnList().doParse(this, ESqlClause.set);
        }
        if (updateNode.getUnSetTerms() != null) {
            this.setUnSetTerms(updateNode.getUnSetTerms());
            this.getUnSetTerms().doParse(this, ESqlClause.unSet);
        }
        if (updateNode.getReferenceTableList() != null) {
            TFromTable lcFromTable = null;
            lcJoin = null;
            for (int i = 0; i < updateNode.getReferenceTableList().size(); ++i) {
                lcFromTable = updateNode.getReferenceTableList().getFromTable(i);
                if (lcFromTable.getFromtableType() != ETableSource.join) {
                    lcJoin = new TJoin();
                    lcTable = this.analyzeFromTable(lcFromTable, true);
                    lcTable.setEffectType(ETableEffectType.tetSelect);
                    lcJoin.setTable(lcTable);
                } else {
                    lcJoin = this.analyzeJoin(lcFromTable.getJoinExpr(), null, true);
                    lcJoin.doParse(this, ESqlClause.join);
                }
                this.joins.addJoin(lcJoin);
            }
        }
        if (updateNode.getLimitClause() != null) {
            this.setLimitClause(updateNode.getLimitClause());
            this.getLimitClause().doParse(this, ESqlClause.limit);
        }
        if (updateNode.getWhereCondition() != null) {
            updateNode.getWhereCondition().doParse(this, ESqlClause.where);
            this.setWhereClause(updateNode.getWhereCondition());
        }
        if (updateNode.getReturningClause() != null) {
            updateNode.getReturningClause().doParse(this, ESqlClause.returning);
            this.setReturningClause(updateNode.getReturningClause());
        }
        this.optionClause = updateNode.getOptionClause();
        this.errorLoggingClause = updateNode.getErrorLoggingClause();
        if (updateNode.getInsertSqlNode() != null) {
            this.insertSqlStatement = new TInsertSqlStatement(this.dbvendor);
            this.insertSqlStatement.rootNode = updateNode.getInsertSqlNode();
            this.insertSqlStatement.doParseStatement(this);
        }
        int[] deletedTables = new int[this.tables.size()];
        TTable lcTable3 = null;
        TTable lcTable2 = null;
        for (int i = 0; i < this.tables.size(); ++i) {
            lcTable3 = this.tables.getTable(i);
            if (lcTable3.getAliasClause() != null || !lcTable3.isBaseTable()) continue;
            for (int j = 0; j < this.tables.size(); ++j) {
                if (i == j || (lcTable2 = this.tables.getTable(j)).getAliasClause() == null || lcTable2.getAliasClause().toString().compareToIgnoreCase(lcTable3.toString()) != 0) continue;
                deletedTables[i] = 1;
                lcTable3.setLinkTable(lcTable2);
            }
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getCteList() != null) {
            this.getCteList().acceptChildren(v);
        }
        if (this.getTopClause() != null) {
            this.getTopClause().acceptChildren(v);
        }
        this.getTargetTable().acceptChildren(v);
        if (this.getOutputClause() != null) {
            this.getOutputClause().acceptChildren(v);
        }
        if (this.joins.size() > 0) {
            this.joins.acceptChildren(v);
        }
        this.getResultColumnList().acceptChildren(v);
        if (this.getWhereClause() != null) {
            this.getWhereClause().acceptChildren(v);
        }
        if (this.getOrderByClause() != null) {
            this.getOrderByClause().acceptChildren(v);
        }
        if (this.getLimitClause() != null) {
            this.getLimitClause().acceptChildren(v);
        }
        if (this.getReturningClause() != null) {
            this.getReturningClause().acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setErrorLoggingClause(TErrorLoggingClause errorLoggingClause) {
        this.errorLoggingClause = errorLoggingClause;
    }

    public void setOptionClause(TOptionClause optionClause) {
        this.optionClause = optionClause;
    }

    public void setReferenceJoins(TJoinList referenceJoins) {
        this.referenceJoins = referenceJoins;
    }

    public void setOrderByClause(TOrderBy orderByClause) {
        this.orderByClause = orderByClause;
    }

    public void setLimitClause(TLimitClause limitClause) {
        this.limitClause = limitClause;
    }

    public void setUseKeyIndex(TUseKeyIndex useKeyIndex) {
        this.useKeyIndex = useKeyIndex;
    }

    public TUseKeyIndex getUseKeyIndex() {
        return this.useKeyIndex;
    }

    public void setUnSetTerms(TResultColumnList unSetTerms) {
        this.unSetTerms = unSetTerms;
    }

    public TResultColumnList getUnSetTerms() {
        return this.unSetTerms;
    }
}

