/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableSource;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TFromTable;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPartitionExtensionClause;
import gudusoft.gsqlparser.nodes.TTruncateTableSqlNode;

public class TTruncateStatement
extends TCustomSqlStatement {
    private TPartitionExtensionClause partitionExtensionClause;
    private TObjectNameList columns;
    private TObjectName tableName;

    public TPartitionExtensionClause getPartitionExtensionClause() {
        return this.partitionExtensionClause;
    }

    public TTruncateStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstTruncate;
    }

    public TObjectName getTableName() {
        return this.tableName;
    }

    public TObjectNameList getColumns() {
        return this.columns;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TTruncateTableSqlNode node = (TTruncateTableSqlNode)this.rootNode;
        if (node.getFromTableList() != null) {
            TFromTable lcFromTable = null;
            TJoin lcJoin = null;
            for (int i = 0; i < node.getFromTableList().size(); ++i) {
                lcFromTable = node.getFromTableList().getFromTable(i);
                if (lcFromTable.getFromtableType() != ETableSource.join) {
                    lcJoin = new TJoin();
                    lcJoin.setTable(this.analyzeFromTable(lcFromTable, true));
                    lcJoin.setStartToken(lcJoin.getTable().getStartToken());
                    lcJoin.setEndToken(lcJoin.getTable().getEndToken());
                    lcJoin.setGsqlparser(this.getGsqlparser());
                } else {
                    lcJoin = this.analyzeJoin(lcFromTable.getJoinExpr(), null, true);
                    lcJoin.doParse(this, ESqlClause.join);
                }
                this.joins.addJoin(lcJoin);
            }
        } else {
            this.tableName = node.getTableName();
            this.analyzeTablename(this.tableName);
        }
        this.partitionExtensionClause = node.getPartitionExtensionClause();
        this.columns = node.getColumns();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setPartitionExtensionClause(TPartitionExtensionClause partitionExtensionClause) {
        this.partitionExtensionClause = partitionExtensionClause;
    }

    public void setColumns(TObjectNameList columns) {
        this.columns = columns;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
    }
}

