/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TLimitClause;
import gudusoft.gsqlparser.nodes.TMergeInsertClause;
import gudusoft.gsqlparser.nodes.TMergeSqlNode;
import gudusoft.gsqlparser.nodes.TMergeUpdateClause;
import gudusoft.gsqlparser.nodes.TMergeWhenClause;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TReturningClause;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.mssql.TOptionClause;
import gudusoft.gsqlparser.nodes.oracle.TErrorLoggingClause;

public class TMergeSqlStatement
extends TCustomSqlStatement {
    private TErrorLoggingClause errorLoggingClause;
    private TOptionClause optionClause;
    private TExpression matchedSearchCondition = null;
    private TExpression notMatchedSearchCondition = null;
    private TObjectNameList columnList = null;
    private TTable usingTable;
    private TExpression condition;
    private TMergeUpdateClause updateClause;
    private TMergeInsertClause insertClause;
    private TPTNodeList<TMergeWhenClause> whenClauses;
    private TLimitClause limitClause;
    private TReturningClause returningClause;

    public TErrorLoggingClause getErrorLoggingClause() {
        return this.errorLoggingClause;
    }

    public TOptionClause getOptionClause() {
        return this.optionClause;
    }

    public TMergeSqlStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstmerge;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    public TExpression getMatchedSearchCondition() {
        return this.matchedSearchCondition;
    }

    public TExpression getNotMatchedSearchCondition() {
        return this.notMatchedSearchCondition;
    }

    public TTable getUsingTable() {
        return this.usingTable;
    }

    public TExpression getCondition() {
        return this.condition;
    }

    public TMergeUpdateClause getUpdateClause() {
        return this.updateClause;
    }

    public TMergeInsertClause getInsertClause() {
        return this.insertClause;
    }

    public TPTNodeList<TMergeWhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        TMergeSqlNode mergeSqlNode = (TMergeSqlNode)this.rootNode;
        super.doParseStatement(psql);
        if (mergeSqlNode.cteList != null) {
            this.setCteList(mergeSqlNode.cteList);
            this.getCteList().doParse(this, ESqlClause.cte);
        }
        TTable lcTable = this.analyzeFromTable(mergeSqlNode.getTargetTable(), true);
        lcTable.setEffectType(ETableEffectType.tetMerge);
        this.setTargetTable(lcTable);
        this.usingTable = this.analyzeFromTable(mergeSqlNode.getUsingTable(), true);
        this.usingTable.setEffectType(ETableEffectType.tetSelect);
        this.condition = mergeSqlNode.getCondition();
        this.condition.doParse(this, ESqlClause.joinCondition);
        if (mergeSqlNode.getColumnList() != null) {
            this.columnList = mergeSqlNode.getColumnList();
            for (int i = 0; i < mergeSqlNode.getColumnList().size(); ++i) {
                TObjectName crf = mergeSqlNode.getColumnList().getObjectName(i);
                crf.setLocation(ESqlClause.mergeInsert);
                this.getTargetTable().getObjectNameReferences().addObjectName(crf);
                this.getTargetTable().getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(this.getTargetTable());
            }
        }
        this.whenClauses = mergeSqlNode.getWhenClauses();
        if (this.whenClauses != null) {
            this.whenClauses.doParse(this, ESqlClause.unknown);
        }
        this.limitClause = mergeSqlNode.getLimitClause();
        if (this.limitClause != null) {
            this.limitClause.doParse(this, ESqlClause.unknown);
        }
        this.returningClause = mergeSqlNode.getReturningClause();
        if (this.returningClause != null) {
            this.returningClause.doParse(this, ESqlClause.unknown);
        }
        if (mergeSqlNode.getOutputClause() != null) {
            mergeSqlNode.getOutputClause().doParse(this, ESqlClause.output);
            this.setOutputClause(mergeSqlNode.getOutputClause());
        }
        this.optionClause = mergeSqlNode.getOptionClause();
        this.errorLoggingClause = mergeSqlNode.getErrorLoggingClause();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.usingTable.acceptChildren(v);
        this.condition.acceptChildren(v);
        if (this.columnList != null) {
            this.columnList.acceptChildren(v);
        }
        if (this.whenClauses != null) {
            this.whenClauses.acceptChildren(v);
        }
        if (this.getOutputClause() != null) {
            this.getOutputClause().acceptChildren(v);
        }
        if (this.errorLoggingClause != null) {
            this.errorLoggingClause.acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setErrorLoggingClause(TErrorLoggingClause errorLoggingClause) {
        this.errorLoggingClause = errorLoggingClause;
    }

    public void setOptionClause(TOptionClause optionClause) {
        this.optionClause = optionClause;
    }

    public void setMatchedSearchCondition(TExpression matchedSearchCondition) {
        this.matchedSearchCondition = matchedSearchCondition;
    }

    public void setNotMatchedSearchCondition(TExpression notMatchedSearchCondition) {
        this.notMatchedSearchCondition = notMatchedSearchCondition;
    }

    public void setColumnList(TObjectNameList columnList) {
        this.columnList = columnList;
    }

    public void setUsingTable(TTable usingTable) {
        this.usingTable = usingTable;
    }

    public void setCondition(TExpression condition) {
        this.condition = condition;
    }

    public void setUpdateClause(TMergeUpdateClause updateClause) {
        this.updateClause = updateClause;
    }

    public void setInsertClause(TMergeInsertClause insertClause) {
        this.insertClause = insertClause;
    }

    public void setWhenClauses(TPTNodeList<TMergeWhenClause> whenClauses) {
        this.whenClauses = whenClauses;
    }

    public void setLimitClause(TLimitClause limitClause) {
        this.limitClause = limitClause;
    }

    public TLimitClause getLimitClause() {
        return this.limitClause;
    }

    @Override
    public void setReturningClause(TReturningClause returningClause) {
        this.returningClause = returningClause;
    }

    @Override
    public TReturningClause getReturningClause() {
        return this.returningClause;
    }
}

