/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.EErrorType;
import gudusoft.gsqlparser.EExpressionType;
import gudusoft.gsqlparser.EInsertSource;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableEffectType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.TSyntaxError;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TFunctionCall;
import gudusoft.gsqlparser.nodes.TInsertCondition;
import gudusoft.gsqlparser.nodes.TInsertIntoValue;
import gudusoft.gsqlparser.nodes.TInsertSqlNode;
import gudusoft.gsqlparser.nodes.TMultiTarget;
import gudusoft.gsqlparser.nodes.TMultiTargetList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TObjectNameList;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TResultColumnList;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.hive.EHiveInsertType;
import gudusoft.gsqlparser.nodes.oracle.TErrorLoggingClause;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import gudusoft.gsqlparser.stmt.mssql.TMssqlExecute;

public class TInsertSqlStatement
extends TCustomSqlStatement {
    private boolean insertAll = false;
    private boolean insertFirst = false;
    private TErrorLoggingClause errorLoggingClause;
    private EHiveInsertType hiveInsertType = EHiveInsertType.intoUnknown;
    private TObjectName directoryName;
    private TPTNodeList<TInsertCondition> insertConditions;
    private TPTNodeList<TInsertIntoValue> insertIntoValues;
    private TSourceToken insertToken = null;
    private TSelectSqlStatement subQuery = null;
    private TFunctionCall functionCall = null;
    private TMssqlExecute executeStmt = null;
    private TObjectName recordName = null;
    private EInsertSource insertSource = EInsertSource.values;
    private TMultiTargetList values = null;
    private int valueType = 1;
    private TResultColumnList setColumnValues = null;
    private TSourceToken ignore;
    private TSourceToken priority_delayed;
    private TResultColumnList onDuplicateKeyUpdate = null;
    private TObjectNameList columnList = null;
    private TPTNodeList<TInsertIntoValue> elseIntoValues;

    public void setInsertAll(boolean insertAll) {
        this.insertAll = insertAll;
    }

    public void setInsertFirst(boolean insertFirst) {
        this.insertFirst = insertFirst;
    }

    public boolean isInsertAll() {
        return this.insertAll;
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    public TErrorLoggingClause getErrorLoggingClause() {
        return this.errorLoggingClause;
    }

    public EHiveInsertType getHiveInsertType() {
        return this.hiveInsertType;
    }

    public TObjectName getDirectoryName() {
        return this.directoryName;
    }

    public TPTNodeList<TInsertCondition> getInsertConditions() {
        return this.insertConditions;
    }

    public TPTNodeList<TInsertIntoValue> getInsertIntoValues() {
        return this.insertIntoValues;
    }

    public void setInsertToken(TSourceToken insertToken) {
        this.insertToken = insertToken;
    }

    public TSourceToken getInsertToken() {
        return this.insertToken;
    }

    public TSelectSqlStatement getSubQuery() {
        return this.subQuery;
    }

    public TFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public TObjectName getRecordName() {
        return this.recordName;
    }

    public EInsertSource getInsertSource() {
        return this.insertSource;
    }

    public int getValueType() {
        return this.valueType;
    }

    public TMultiTargetList getValues() {
        return this.values;
    }

    public TResultColumnList getOnDuplicateKeyUpdate() {
        return this.onDuplicateKeyUpdate;
    }

    public TSourceToken getIgnore() {
        return this.ignore;
    }

    public TSourceToken getPriority_delayed() {
        return this.priority_delayed;
    }

    public TResultColumnList getSetColumnValues() {
        return this.setColumnValues;
    }

    public TInsertSqlStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstinsert;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    public TObjectNameList getColumnList() {
        return this.columnList;
    }

    public void setValues(TMultiTargetList values) {
        this.values = values;
    }

    public void setColumnList(TObjectNameList columnList) {
        this.columnList = columnList;
    }

    public void setSubQuery(TSelectSqlStatement subQuery) {
        this.insertSource = EInsertSource.subquery;
        this.subQuery = subQuery;
    }

    public TMssqlExecute getExecuteStmt() {
        return this.executeStmt;
    }

    public TPTNodeList<TInsertIntoValue> getElseIntoValues() {
        return this.elseIntoValues;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        TInsertSqlNode insertNode = (TInsertSqlNode)this.rootNode;
        if (this.sourcetokenlist.size() == 0) {
            this.setStartToken(insertNode.getStartToken());
            this.setEndToken(insertNode.getEndToken());
        }
        super.doParseStatement(psql);
        this.insertToken = insertNode.getInsertToken();
        this.ignore = insertNode.getIgnore();
        this.priority_delayed = insertNode.getPriority_delayed();
        this.insertAll = insertNode.isInsertAll();
        this.insertFirst = insertNode.isInsertFirst();
        this.valueType = insertNode.getValueType();
        if (this.dbvendor == EDbVendor.dbvhive) {
            this.hiveInsertType = insertNode.getHiveInsertType();
            this.directoryName = insertNode.getDirectoryName();
        }
        if (insertNode.cteList != null) {
            this.setCteList(insertNode.cteList);
            this.getCteList().doParse(this, ESqlClause.cte);
        }
        if (insertNode.getTopClause() != null) {
            insertNode.getTopClause().doParse(this, ESqlClause.top);
            this.setTopClause(insertNode.getTopClause());
        }
        if (this.valueType != 9 && insertNode.getTargetTable() != null) {
            TTable lcTable = this.analyzeFromTable(insertNode.getTargetTable(), true);
            lcTable.setEffectType(ETableEffectType.tetInsert);
            this.setTargetTable(lcTable);
        }
        if (insertNode.getColumnList() != null) {
            this.columnList = insertNode.getColumnList();
            for (int i = 0; i < insertNode.getColumnList().size(); ++i) {
                TObjectName crf = insertNode.getColumnList().getObjectName(i);
                crf.setLocation(ESqlClause.insertColumn);
                this.getTargetTable().getObjectNameReferences().addObjectName(crf);
                this.getTargetTable().getLinkedColumns().addObjectName(crf);
                crf.setSourceTable(this.getTargetTable());
            }
        }
        if (insertNode.getOutputClause() != null) {
            insertNode.getOutputClause().doParse(this, ESqlClause.output);
            this.setOutputClause(insertNode.getOutputClause());
        }
        switch (this.valueType) {
            case 1: {
                this.insertSource = EInsertSource.values;
                insertNode.getValues().doParse(this, ESqlClause.insertValues);
                this.values = insertNode.getValues();
                if (this.columnList == null) break;
                for (int k = 0; k < this.values.size(); ++k) {
                    TMultiTarget mt = this.values.getMultiTarget(k);
                    if (mt.getColumnList() == null || mt.getColumnList().size() == 0 || mt.getColumnList().getResultColumn(0).getExpr() == null || mt.getColumnList().getResultColumn(0).getExpr().getExpressionType() == EExpressionType.subquery_t || mt.getColumnList().size() == this.columnList.size()) continue;
                    TSourceToken st1 = mt.getColumnList().getStartToken();
                    TSyntaxError err = new TSyntaxError(st1.toString(), st1.lineNo, st1.columnNo, String.format("value count(%d) is not the same as column list(%d)", mt.getColumnList().size(), this.columnList.size()), EErrorType.sperror, 10111);
                    this.parseerrormessagehandle(err);
                }
                break;
            }
            case 6: {
                this.insertSource = EInsertSource.values_empty;
                break;
            }
            case 9: {
                this.insertSource = EInsertSource.values_multi_table;
                if (this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(this.dbvendor);
                    this.subQuery.rootNode = insertNode.getSubQueryNode();
                }
                this.subQuery.doParseStatement(this);
                break;
            }
            case 2: {
                this.insertSource = EInsertSource.subquery;
                if (this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(this.dbvendor);
                    this.subQuery.rootNode = insertNode.getSubQueryNode();
                }
                this.subQuery.doParseStatement(this);
                break;
            }
            case 11: {
                this.insertSource = EInsertSource.hive_query;
                if (this.subQuery == null) {
                    this.subQuery = new TSelectSqlStatement(this.dbvendor);
                    this.subQuery.rootNode = insertNode.getSubQueryNode();
                }
                this.subQuery.doParseStatement(this);
                break;
            }
            case 3: {
                this.insertSource = EInsertSource.default_values;
                break;
            }
            case 4: {
                this.insertSource = EInsertSource.execute;
                this.executeStmt = new TMssqlExecute(EDbVendor.dbvmssql);
                this.executeStmt.rootNode = insertNode.getExecuteSqlNode();
                this.executeStmt.doParseStatement(this);
                break;
            }
            case 5: {
                this.insertSource = EInsertSource.values_function;
                insertNode.getFunctionCall().doParse(this, ESqlClause.insertValues);
                this.functionCall = insertNode.getFunctionCall();
                break;
            }
            case 8: {
                this.insertSource = EInsertSource.values_oracle_record;
                insertNode.getRecordName().doParse(this, ESqlClause.insertValues);
                this.recordName = insertNode.getRecordName();
                break;
            }
            case 7: {
                this.insertSource = EInsertSource.set_column_value;
                this.setColumnValues = insertNode.getSetColumnValues();
                this.setColumnValues.doParse(this, ESqlClause.insertValues);
            }
        }
        if (insertNode.getInsertConditions() != null) {
            this.valueType = 9;
            this.insertConditions = insertNode.getInsertConditions();
            this.insertConditions.doParse(this, ESqlClause.insertValues);
            this.setTargetTable(this.insertConditions.getElement(0).getInsertIntoValues().getElement(0).getTable());
        }
        if (insertNode.getInsertIntoValues() != null) {
            this.valueType = 9;
            this.insertIntoValues = insertNode.getInsertIntoValues();
            this.insertIntoValues.doParse(this, ESqlClause.insertValues);
            this.setTargetTable(this.insertIntoValues.getElement(0).getTable());
        }
        if (insertNode.getElseIntoValues() != null) {
            this.valueType = 9;
            this.elseIntoValues = insertNode.getElseIntoValues();
            this.elseIntoValues.doParse(this, ESqlClause.insertValues);
            this.setTargetTable(this.elseIntoValues.getElement(0).getTable());
        }
        if (insertNode.getReturningClause() != null) {
            insertNode.getReturningClause().doParse(this, ESqlClause.returning);
            this.setReturningClause(insertNode.getReturningClause());
        }
        if (insertNode.getOnDuplicateKeyUpdate() != null) {
            this.onDuplicateKeyUpdate = insertNode.getOnDuplicateKeyUpdate();
            this.onDuplicateKeyUpdate.doParse(this, ESqlClause.unknown);
        }
        this.errorLoggingClause = insertNode.getErrorLoggingClause();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getCteList() != null) {
            this.getCteList().acceptChildren(v);
        }
        if (this.getTopClause() != null) {
            this.getTopClause().acceptChildren(v);
        }
        if (this.getTargetTable() != null) {
            this.getTargetTable().acceptChildren(v);
        }
        if (this.getColumnList() != null) {
            this.getColumnList().acceptChildren(v);
        }
        if (this.getOutputClause() != null) {
            this.getOutputClause().acceptChildren(v);
        }
        switch (this.getValueType()) {
            case 1: {
                this.getValues().acceptChildren(v);
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                this.getSubQuery().acceptChildren(v);
                break;
            }
            case 5: {
                this.getFunctionCall().acceptChildren(v);
                break;
            }
            case 8: {
                this.getRecordName().acceptChildren(v);
                break;
            }
            case 7: {
                this.getSetColumnValues().acceptChildren(v);
                break;
            }
        }
        if (this.getReturningClause() != null) {
            this.getReturningClause().acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setErrorLoggingClause(TErrorLoggingClause errorLoggingClause) {
        this.errorLoggingClause = errorLoggingClause;
    }

    public void setHiveInsertType(EHiveInsertType hiveInsertType) {
        this.hiveInsertType = hiveInsertType;
    }

    public void setDirectoryName(TObjectName directoryName) {
        this.directoryName = directoryName;
    }

    public void setInsertConditions(TPTNodeList<TInsertCondition> insertConditions) {
        this.insertConditions = insertConditions;
    }

    public void setInsertIntoValues(TPTNodeList<TInsertIntoValue> insertIntoValues) {
        this.insertIntoValues = insertIntoValues;
    }

    public void setFunctionCall(TFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public void setExecuteStmt(TMssqlExecute executeStmt) {
        this.executeStmt = executeStmt;
    }

    public void setRecordName(TObjectName recordName) {
        this.recordName = recordName;
    }

    public void setInsertSource(EInsertSource insertSource) {
        this.insertSource = insertSource;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public void setSetColumnValues(TResultColumnList setColumnValues) {
        this.setColumnValues = setColumnValues;
    }

    public void setOnDuplicateKeyUpdate(TResultColumnList onDuplicateKeyUpdate) {
        this.onDuplicateKeyUpdate = onDuplicateKeyUpdate;
    }
}

