/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbObjectType;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.ETableKind;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TColumnDefinition;
import gudusoft.gsqlparser.nodes.TColumnDefinitionList;
import gudusoft.gsqlparser.nodes.TConstraintList;
import gudusoft.gsqlparser.nodes.TCreateTableSqlNode;
import gudusoft.gsqlparser.nodes.TMySQLCreateTableOption;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TResultColumn;
import gudusoft.gsqlparser.nodes.TTable;
import gudusoft.gsqlparser.nodes.TTableElement;
import gudusoft.gsqlparser.nodes.hive.THiveRowFormat;
import gudusoft.gsqlparser.nodes.hive.THiveTableBuckets;
import gudusoft.gsqlparser.nodes.hive.THiveTableFileFormat;
import gudusoft.gsqlparser.nodes.hive.THiveTablePartition;
import gudusoft.gsqlparser.nodes.hive.THiveTableProperties;
import gudusoft.gsqlparser.nodes.hive.THiveTableSkewed;
import gudusoft.gsqlparser.nodes.oracle.TPhysicalProperties;
import gudusoft.gsqlparser.nodes.teradata.TIndexDefinition;
import gudusoft.gsqlparser.sqlenv.TSQLEnv;
import gudusoft.gsqlparser.sqlenv.TSQLTable;
import gudusoft.gsqlparser.stmt.TExecutePreparedStatement;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;
import java.util.EnumSet;

public class TCreateTableSqlStatement
extends TCustomSqlStatement {
    private TPhysicalProperties physicalProperties;
    private EnumSet<ETableKind> tableKinds = EnumSet.noneOf(ETableKind.class);
    private TTable asTable;
    private boolean externalTable;
    private TPTNodeList<TIndexDefinition> indexDefinitions;
    private boolean external;
    private boolean ifNotExists;
    private TObjectName tableLocation;
    private TObjectName tableComment;
    private THiveTableProperties hiveTableProperties;
    private THiveTablePartition hiveTablePartition;
    private THiveTableBuckets hiveTableBuckets;
    private THiveTableSkewed hiveTableSkewed;
    private THiveRowFormat hiveRowFormat;
    private THiveTableFileFormat hiveTableFileFormat;
    private TObjectName likeTableName;
    private TObjectName rowTypeName;
    private TObjectName superTableName;
    private TSelectSqlStatement subQuery = null;
    private TExecutePreparedStatement executePreparedStatement = null;
    private TPTNodeList<TMySQLCreateTableOption> mySQLTableOptionList;
    private TObjectName tableName = null;
    private TColumnDefinitionList columnList = null;
    private TConstraintList tableConstraints = null;

    public TPhysicalProperties getPhysicalProperties() {
        return this.physicalProperties;
    }

    public void setTableKinds(EnumSet<ETableKind> tableKinds) {
        this.tableKinds = tableKinds;
    }

    public EnumSet<ETableKind> getTableKinds() {
        return this.tableKinds;
    }

    public TTable getAsTable() {
        return this.asTable;
    }

    public boolean isExternalTable() {
        return this.externalTable;
    }

    public TPTNodeList<TIndexDefinition> getIndexDefinitions() {
        return this.indexDefinitions;
    }

    public boolean isExternal() {
        return this.external;
    }

    public THiveRowFormat getHiveRowFormat() {
        return this.hiveRowFormat;
    }

    public THiveTableBuckets getHiveTableBuckets() {
        return this.hiveTableBuckets;
    }

    public THiveTableFileFormat getHiveTableFileFormat() {
        return this.hiveTableFileFormat;
    }

    public THiveTablePartition getHiveTablePartition() {
        return this.hiveTablePartition;
    }

    public THiveTableProperties getHiveTableProperties() {
        return this.hiveTableProperties;
    }

    public THiveTableSkewed getHiveTableSkewed() {
        return this.hiveTableSkewed;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public TObjectName getLikeTableName() {
        return this.likeTableName;
    }

    public TObjectName getTableComment() {
        return this.tableComment;
    }

    public TObjectName getTableLocation() {
        return this.tableLocation;
    }

    public TObjectName getRowTypeName() {
        return this.rowTypeName;
    }

    public TObjectName getSuperTableName() {
        return this.superTableName;
    }

    public TSelectSqlStatement getSubQuery() {
        return this.subQuery;
    }

    public TExecutePreparedStatement getExecutePreparedStatement() {
        return this.executePreparedStatement;
    }

    public TPTNodeList<TMySQLCreateTableOption> getMySQLTableOptionList() {
        return this.mySQLTableOptionList;
    }

    public TCreateTableSqlStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcreatetable;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    public TObjectName getTableName() {
        return this.tables.getTable(0).getTableName();
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        int i;
        if (this.rootNode == null) {
            return -1;
        }
        TCreateTableSqlNode createTableNode = (TCreateTableSqlNode)this.rootNode;
        super.doParseStatement(psql);
        this.tableKinds = createTableNode.getTableKinds();
        this.setTargetTable(createTableNode.getTable());
        TSQLTable sqlTable = null;
        if (this.getSqlEnv() != null && createTableNode.getTable() != null) {
            sqlTable = this.getSqlEnv().addTable(createTableNode.getTable().getFullName(), true);
        }
        this.externalTable = createTableNode.isExternalTable();
        this.physicalProperties = createTableNode.getPhysicalProperties();
        this.mySQLTableOptionList = createTableNode.getMySQLTableOptionList();
        this.superTableName = createTableNode.getSuperTableName();
        this.rowTypeName = createTableNode.getRowTypeName();
        this.tables.addTable(createTableNode.getTable());
        this.asTable = createTableNode.getAsTable();
        if (this.asTable != null) {
            this.tables.addTable(this.asTable);
        }
        if (createTableNode.getTableElementList() != null && createTableNode.getTableElementList().size() > 0) {
            for (i = 0; i < createTableNode.getTableElementList().size(); ++i) {
                TTableElement te = createTableNode.getTableElementList().getTableElement(i);
                if (te.getType() == 1) {
                    this.getColumnList().addColumn(te.getColumnDefinition());
                    TColumnDefinition cd = te.getColumnDefinition();
                    cd.doParse(this, ESqlClause.createTable);
                    this.getTargetTable().getObjectNameReferences().addObjectName(cd.getColumnName());
                    cd.getColumnName().setLocation(ESqlClause.createTable);
                    cd.getColumnName().setLinkedColumnDef(cd);
                    this.getTargetTable().getLinkedColumns().addObjectName(cd.getColumnName());
                    cd.getColumnName().setSourceTable(this.getTargetTable());
                    if (sqlTable == null) continue;
                    sqlTable.addColumn(cd.getColumnName().toString());
                    continue;
                }
                if (te.getType() == 3) {
                    this.likeTableName = te.getParentTable();
                    continue;
                }
                if (te.getType() == 4) continue;
                te.getConstraint().doParse(this, ESqlClause.unknown);
                this.getTableConstraints().addConstraint(te.getConstraint());
            }
        }
        TColumnDefinition t = null;
        if (createTableNode.getColumnList() != null && createTableNode.getColumnList().size() > 0) {
            for (int i2 = 0; i2 < createTableNode.getColumnList().size(); ++i2) {
                t = new TColumnDefinition(createTableNode.getColumnList().getObjectName(i2));
                t.setStartToken(t.getColumnName().getStartToken());
                t.setEndToken(t.getColumnName().getEndToken());
                this.getColumnList().addColumn(t);
                this.getTargetTable().getObjectNameReferences().addObjectName(createTableNode.getColumnList().getObjectName(i2));
                this.getTargetTable().getLinkedColumns().addObjectName(createTableNode.getColumnList().getObjectName(i2));
                createTableNode.getColumnList().getObjectName(i2).setSourceTable(this.getTargetTable());
                if (sqlTable == null) continue;
                sqlTable.addColumn(createTableNode.getColumnList().getObjectName(i2).toString());
            }
        }
        if (this.subQuery == null && createTableNode.getSubQueryNode() != null) {
            this.subQuery = new TSelectSqlStatement(this.dbvendor);
            this.subQuery.rootNode = createTableNode.getSubQueryNode();
            this.subQuery.doParseStatement(this);
            if (createTableNode.getColumnList() == null) {
                TSelectSqlStatement viewQuery = this.subQuery;
                if (this.subQuery.isCombinedQuery()) {
                    viewQuery = this.subQuery.getRightStmt();
                }
                for (i = 0; i < viewQuery.getResultColumnList().size(); ++i) {
                    TResultColumn resultColumn = viewQuery.getResultColumnList().getResultColumn(i);
                    TObjectName aliasName = null;
                    if (resultColumn.getAliasClause() != null) {
                        aliasName = new TObjectName(resultColumn.getAliasClause().getAliasName().getObjectToken(), EDbObjectType.column);
                        aliasName.getReferencedObjects().addObjectName(resultColumn.getAliasClause().getAliasName());
                        aliasName.setLocation(resultColumn.getAliasClause().getAliasName().getLocation());
                    } else if (resultColumn.getExpr().getObjectOperand() != null) {
                        aliasName = new TObjectName(resultColumn.getExpr().getObjectOperand().getPartToken(), EDbObjectType.column);
                        aliasName.getReferencedObjects().addObjectName(resultColumn.getExpr().getObjectOperand());
                        aliasName.setLocation(resultColumn.getExpr().getObjectOperand().getLocation());
                    }
                    if (aliasName == null) continue;
                    if (aliasName.getLocation() == ESqlClause.unknown) {
                        aliasName.setLocation(ESqlClause.columnAlias);
                    }
                    this.getTargetTable().getLinkedColumns().addObjectName(aliasName);
                    aliasName.setSourceTable(this.getTargetTable());
                    if (sqlTable == null) continue;
                    sqlTable.addColumn(TSQLEnv.getObjectName(aliasName.toString()));
                }
            }
        }
        if (createTableNode.getExecuteSqlNode() != null) {
            this.executePreparedStatement = new TExecutePreparedStatement(this.dbvendor);
            this.executePreparedStatement.rootNode = createTableNode.getExecuteSqlNode();
            this.executePreparedStatement.doParseStatement(this);
        }
        this.external = createTableNode.isExternal();
        this.ifNotExists = createTableNode.isIfNotExists();
        this.tableComment = createTableNode.getTableComment();
        this.tableLocation = createTableNode.getTableLocation();
        this.hiveTableProperties = createTableNode.getHiveTableProperties();
        this.hiveTablePartition = createTableNode.getHiveTablePartition();
        this.hiveTableBuckets = createTableNode.getHiveTableBuckets();
        this.hiveRowFormat = createTableNode.getHiveRowFormat();
        this.hiveTableSkewed = createTableNode.getHiveTableSkewed();
        this.hiveTableFileFormat = createTableNode.getHiveTableFileFormat();
        if (this.likeTableName == null) {
            this.likeTableName = createTableNode.getLikeTableName();
        }
        this.indexDefinitions = createTableNode.getIndexDefinitions();
        if (this.indexDefinitions != null) {
            for (int i3 = 0; i3 < this.indexDefinitions.size(); ++i3) {
                this.indexDefinitions.getElement(i3).doParse(this, ESqlClause.tableIndexOption);
            }
        }
        return 0;
    }

    public TConstraintList getTableConstraints() {
        if (this.tableConstraints == null) {
            this.tableConstraints = new TConstraintList();
        }
        return this.tableConstraints;
    }

    public TColumnDefinitionList getColumnList() {
        if (this.columnList == null) {
            this.columnList = new TColumnDefinitionList();
        }
        return this.columnList;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.getColumnList().acceptChildren(v);
        if (this.getTableConstraints() != null && this.getTableConstraints().size() > 0) {
            this.getTableConstraints().acceptChildren(v);
        }
        if (this.getSubQuery() != null) {
            this.getSubQuery().acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setColumnList(TColumnDefinitionList columnList) {
        this.columnList = columnList;
    }

    public void setAsTable(TTable asTable) {
        this.asTable = asTable;
    }

    public void setExternalTable(boolean externalTable) {
        this.externalTable = externalTable;
    }

    public void setIndexDefinitions(TPTNodeList<TIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setTableLocation(TObjectName tableLocation) {
        this.tableLocation = tableLocation;
    }

    public void setTableComment(TObjectName tableComment) {
        this.tableComment = tableComment;
    }

    public void setHiveTableProperties(THiveTableProperties hiveTableProperties) {
        this.hiveTableProperties = hiveTableProperties;
    }

    public void setHiveTablePartition(THiveTablePartition hiveTablePartition) {
        this.hiveTablePartition = hiveTablePartition;
    }

    public void setHiveTableBuckets(THiveTableBuckets hiveTableBuckets) {
        this.hiveTableBuckets = hiveTableBuckets;
    }

    public void setHiveTableSkewed(THiveTableSkewed hiveTableSkewed) {
        this.hiveTableSkewed = hiveTableSkewed;
    }

    public void setHiveRowFormat(THiveRowFormat hiveRowFormat) {
        this.hiveRowFormat = hiveRowFormat;
    }

    public void setHiveTableFileFormat(THiveTableFileFormat hiveTableFileFormat) {
        this.hiveTableFileFormat = hiveTableFileFormat;
    }

    public void setLikeTableName(TObjectName likeTableName) {
        this.likeTableName = likeTableName;
    }

    public void setRowTypeName(TObjectName rowTypeName) {
        this.rowTypeName = rowTypeName;
    }

    public void setSuperTableName(TObjectName superTableName) {
        this.superTableName = superTableName;
    }

    public void setSubQuery(TSelectSqlStatement subQuery) {
        this.subQuery = subQuery;
    }

    public void setExecutePreparedStatement(TExecutePreparedStatement executePreparedStatement) {
        this.executePreparedStatement = executePreparedStatement;
    }

    public void setMySQLTableOptionList(TPTNodeList<TMySQLCreateTableOption> mySQLTableOptionList) {
        this.mySQLTableOptionList = mySQLTableOptionList;
    }

    public void setTableName(TObjectName tableName) {
        this.tableName = tableName;
    }

    public void setTableConstraints(TConstraintList tableConstraints) {
        this.tableConstraints = tableConstraints;
    }
}

