/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TStackFrame;
import gudusoft.gsqlparser.TSymbolVariable;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TCreateProcedureSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSymbolTableItem;
import gudusoft.gsqlparser.nodes.TTypeName;
import gudusoft.gsqlparser.stmt.TCommonBlock;
import gudusoft.gsqlparser.stmt.TRoutine;

public class TCreateProcedureStmt
extends TRoutine {
    private TObjectName outerLabelName = null;
    private TObjectName functionName = null;
    private TTypeName returnDataType = null;
    private TConstant objfile;
    private TConstant linkSymbol;
    private TConstant procedureLanguage;
    private TObjectName endlabelName;
    private TObjectName procedureName = null;

    public TConstant getProcedureLanguage() {
        return this.procedureLanguage;
    }

    public TObjectName getOuterLabelName() {
        return this.outerLabelName;
    }

    public TConstant getLinkSymbol() {
        return this.linkSymbol;
    }

    public TConstant getObjfile() {
        return this.objfile;
    }

    public TCreateProcedureStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcreateprocedure;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    @Override
    public TObjectName getEndlabelName() {
        return this.endlabelName;
    }

    @Override
    public TObjectName getStoredProcedureName() {
        return this.procedureName;
    }

    public TObjectName getProcedureName() {
        return this.procedureName;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        int i;
        if (this.rootNode == null) {
            return -1;
        }
        TCreateProcedureSqlNode createProcedureNode = (TCreateProcedureSqlNode)this.rootNode;
        super.doParseStatement(psql);
        TStackFrame currentStackFrame = new TStackFrame(this.stmtScope);
        currentStackFrame.pushStack(this.getFrameStack());
        this.procedureName = createProcedureNode.getProcedureName();
        if (this.getSqlEnv() != null) {
            this.getSqlEnv().addProcedure(this.procedureName.toString(), true);
        }
        this.setRoutineName(this.procedureName);
        this.procedureLanguage = createProcedureNode.getProcedureLanguage();
        if (this.procedureLanguage != null) {
            this.setRoutineLanguageInConstant(this.procedureLanguage);
            this.setRoutineLanguage(this.procedureLanguage.toString());
        }
        this.outerLabelName = createProcedureNode.getLabelName();
        this.objfile = createProcedureNode.getObjfile();
        this.linkSymbol = createProcedureNode.getLinkSymbol();
        if (createProcedureNode.getFunctionBody() != null) {
            this.setRoutineBodyInConstant(createProcedureNode.getFunctionBody());
            this.setRoutineBody(createProcedureNode.getFunctionBody().toString());
        }
        this.setParameterDeclarations(createProcedureNode.getParameters());
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(9, (TCustomSqlStatement)this, (TParseTreeNode)this.getParameterDeclarations().getParameterDeclarationItem(i)));
                TParameterDeclaration parameterDeclaration = this.getParameterDeclarations().getParameterDeclarationItem(i);
                if (parameterDeclaration.getParameterName() == null) continue;
                this.stmtScope.addSymbol(new TSymbolVariable(parameterDeclaration.getParameterName(), parameterDeclaration, this.procedureName));
            }
        }
        if (createProcedureNode.getDeclareStmts() != null) {
            createProcedureNode.getDeclareStmts().doParse(this, ESqlClause.unknown);
            for (i = 0; i < createProcedureNode.getDeclareStmts().size(); ++i) {
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(10, (TCustomSqlStatement)this, (TParseTreeNode)createProcedureNode.getDeclareStmts().getStatementSqlNode(i).getStmt()));
                this.getDeclareStatements().add(createProcedureNode.getDeclareStmts().getStatementSqlNode(i).getStmt());
            }
        }
        if (createProcedureNode.getStmt() != null) {
            createProcedureNode.getStmt().doParse(this, ESqlClause.unknown);
            this.getBodyStatements().add(createProcedureNode.getStmt().getStmt());
        } else if (createProcedureNode.getBlcok() != null) {
            createProcedureNode.getBlcok().getStmts().doParse(this, ESqlClause.unknown);
            for (i = 0; i < createProcedureNode.getBlcok().getStmts().size(); ++i) {
                this.getBodyStatements().add(createProcedureNode.getBlcok().getStmts().getStatementSqlNode(i).getStmt());
            }
        }
        if (createProcedureNode.getExceptionClause() != null) {
            createProcedureNode.getExceptionClause().doParse(this, ESqlClause.unknown);
            this.setExceptionClause(createProcedureNode.getExceptionClause());
        }
        if (createProcedureNode.getDeclareStmts() != null) {
            for (i = 0; i < createProcedureNode.getDeclareStmts().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        switch (this.dbvendor) {
            case dbvpostgresql: 
            case dbvredshift: {
                this.postgresqlProcedureDefinition(psql, createProcedureNode);
            }
        }
        this.endlabelName = createProcedureNode.getEndlabelName();
        currentStackFrame.popStack(this.getFrameStack());
        return 0;
    }

    private void postgresqlProcedureDefinition(TCustomSqlStatement psql, TCreateProcedureSqlNode createProcedureNode) {
        block12: {
            if (createProcedureNode.getFunctionBody() == null || this.getProcedureLanguage().toString() == null || !this.getProcedureLanguage().toString().equalsIgnoreCase("sql") && !this.getProcedureLanguage().toString().equalsIgnoreCase("plpgsql")) break block12;
            String bodyStr = createProcedureNode.getFunctionBody().getStartToken().getQuotedString();
            if (createProcedureNode.getFunctionBody().getStartToken().toString().startsWith("'")) {
                bodyStr = bodyStr.replaceAll("''", "'");
            }
            String prefixStr = bodyStr.trim().substring(0, 9).toLowerCase();
            boolean isSQLBlock = true;
            TGSqlParser newParser = new TGSqlParser(EDbVendor.dbvpostgresql);
            if (prefixStr.startsWith("declare") || prefixStr.startsWith("begin") || prefixStr.startsWith("<<")) {
                newParser.sqltext = "plpgsql_function_delimiter " + TBaseType.stringBlock((int)createProcedureNode.getFunctionBody().getStartToken().lineNo - 1, (int)createProcedureNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
            } else {
                newParser.sqltext = "\n" + TBaseType.stringBlock((int)createProcedureNode.getFunctionBody().getStartToken().lineNo - 1, (int)createProcedureNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
                isSQLBlock = false;
            }
            newParser.setFrameStack(this.getFrameStack());
            int iRet = newParser.parse();
            if (iRet == 0 && newParser.getSqlstatements().size() > 0) {
                if (isSQLBlock) {
                    int i;
                    TCommonBlock commonBlock = (TCommonBlock)newParser.getSqlstatements().get(0);
                    this.setOuterLabelName(commonBlock.getLabelName());
                    for (i = 0; i < commonBlock.getDeclareStatements().size(); ++i) {
                        this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(10, (TCustomSqlStatement)this, (TParseTreeNode)commonBlock.getDeclareStatements().get(i)));
                        this.getDeclareStatements().add(commonBlock.getDeclareStatements().get(i));
                    }
                    for (i = 0; i < commonBlock.getBodyStatements().size(); ++i) {
                        commonBlock.getBodyStatements().get(i).setAlreadyAddToParent(false);
                        commonBlock.getBodyStatements().get(i).setParentStmt(this);
                        this.getBodyStatements().add(commonBlock.getBodyStatements().get(i));
                    }
                    if (commonBlock.getExceptionClause() != null) {
                        this.setExceptionClause(commonBlock.getExceptionClause());
                    }
                    for (i = 0; i < commonBlock.getDeclareStatements().size(); ++i) {
                        this.getTopStatement().getSymbolTable().pop();
                    }
                } else {
                    this.getBodyStatements().add(newParser.getSqlstatements().get(0));
                }
            } else {
                for (int j = 0; j < newParser.getErrorCount(); ++j) {
                    this.parseerrormessagehandle(newParser.getSyntaxErrors().get(j));
                }
            }
        }
    }

    public void setOuterLabelName(TObjectName outerLabelName) {
        this.outerLabelName = outerLabelName;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getParameterDeclarations() != null) {
            this.getParameterDeclarations().acceptChildren(v);
        }
        this.getBodyStatements().acceptChildren(v);
        v.postVisit(this);
    }

    public void setProcedureName(TObjectName procedureName) {
        this.procedureName = procedureName;
    }
}

