/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TCreateMaterializedViewSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TViewAliasClause;
import gudusoft.gsqlparser.nodes.oracle.TMaterializedViewProps;
import gudusoft.gsqlparser.nodes.oracle.TOracleCreateMvRefresh;
import gudusoft.gsqlparser.nodes.oracle.TOracleUsingIndex;
import gudusoft.gsqlparser.nodes.oracle.TPhysicalProperties;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

public class TCreateMaterializedSqlStatement
extends TCustomSqlStatement {
    private TSelectSqlStatement subquery = null;
    private TViewAliasClause viewAliasClause = null;
    private boolean forUpdate = false;
    private TOracleUsingIndex oracleUsingIndex;
    private TOracleCreateMvRefresh mvRefresh;
    private TObjectName viewName = null;
    private TPhysicalProperties physicalProperties;
    private TMaterializedViewProps materializedViewProps;

    public TOracleCreateMvRefresh getMvRefresh() {
        return this.mvRefresh;
    }

    public TOracleUsingIndex getOracleUsingIndex() {
        return this.oracleUsingIndex;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public TViewAliasClause getViewAliasClause() {
        return this.viewAliasClause;
    }

    public TSelectSqlStatement getSubquery() {
        return this.subquery;
    }

    public TCreateMaterializedSqlStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcreatematerializedview;
    }

    public TObjectName getViewName() {
        return this.viewName;
    }

    public TPhysicalProperties getPhysicalProperties() {
        return this.physicalProperties;
    }

    public TMaterializedViewProps getMaterializedViewProps() {
        return this.materializedViewProps;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        TCreateMaterializedViewSqlNode createViewSqlNode = (TCreateMaterializedViewSqlNode)this.rootNode;
        super.doParseStatement(psql);
        this.viewName = createViewSqlNode.getViewName();
        this.oracleUsingIndex = createViewSqlNode.getOracleUsingIndex();
        this.mvRefresh = createViewSqlNode.getMvRefresh();
        this.physicalProperties = createViewSqlNode.getPhysicalProperties();
        this.materializedViewProps = createViewSqlNode.getMaterializedViewProps();
        this.forUpdate = createViewSqlNode.isForUpdate();
        this.subquery = new TSelectSqlStatement(this.dbvendor);
        this.subquery.rootNode = createViewSqlNode.getSelectSqlNode();
        this.subquery.doParseStatement(this);
        if (createViewSqlNode.getViewAliasClause() != null) {
            createViewSqlNode.getViewAliasClause().doParse(this, ESqlClause.viewAlias);
            this.viewAliasClause = createViewSqlNode.getViewAliasClause();
        }
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        this.subquery.acceptChildren(v);
        if (this.viewAliasClause != null) {
            this.viewAliasClause.acceptChildren(v);
        }
        v.postVisit(this);
    }

    public void setSubquery(TSelectSqlStatement subquery) {
        this.subquery = subquery;
    }

    public void setViewAliasClause(TViewAliasClause viewAliasClause) {
        this.viewAliasClause = viewAliasClause;
    }

    public void setViewName(TObjectName viewName) {
        this.viewName = viewName;
    }
}

