/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlClause;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TBaseType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TGSqlParser;
import gudusoft.gsqlparser.TStackFrame;
import gudusoft.gsqlparser.TSymbolVariable;
import gudusoft.gsqlparser.TVisitorAbs;
import gudusoft.gsqlparser.nodes.TConstant;
import gudusoft.gsqlparser.nodes.TCreateFunctionSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParameterDeclaration;
import gudusoft.gsqlparser.nodes.TParseTreeNode;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TSymbolTableItem;
import gudusoft.gsqlparser.stmt.TRoutine;

public class TCreateFunctionStmt
extends TRoutine {
    private TObjectName endlabelName;
    private TObjectName functionName = null;
    private String sharedLibraryName;
    private TConstant functionDefinition;
    private TConstant procedureLanguage;

    public TCreateFunctionStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcreatefunction;
    }

    void buildsql() {
    }

    void clear() {
    }

    String getasprettytext() {
        return "";
    }

    void iterate(TVisitorAbs pvisitor) {
    }

    @Override
    public TObjectName getStoredProcedureName() {
        return this.functionName;
    }

    @Override
    public TObjectName getEndlabelName() {
        return this.endlabelName;
    }

    public TObjectName getFunctionName() {
        return this.functionName;
    }

    public String getSharedLibraryName() {
        return this.sharedLibraryName;
    }

    public TConstant getFunctionDefinition() {
        return this.functionDefinition;
    }

    public TConstant getProcedureLanguage() {
        return this.procedureLanguage;
    }

    private void redshiftFunctionDefinition(TCustomSqlStatement psql, TCreateFunctionSqlNode createFunctionNode) {
        if (createFunctionNode.getFunctionBody() != null && this.getProcedureLanguage().toString().equalsIgnoreCase("sql")) {
            String bodyStr = createFunctionNode.getFunctionBody().getStartToken().getQuotedString().trim();
            if (createFunctionNode.getFunctionBody().getStartToken().toString().startsWith("'")) {
                bodyStr = bodyStr.replaceAll("''", "'");
            }
            String prefixStr = bodyStr.substring(0, 9).toLowerCase();
            boolean isExpression = true;
            TGSqlParser newParser = new TGSqlParser(this.dbvendor);
            newParser.sqltext = "\n" + TBaseType.stringBlock((int)createFunctionNode.getFunctionBody().getStartToken().lineNo, (int)createFunctionNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
            newParser.setFrameStack(this.getFrameStack());
            int iRet = newParser.parse();
            if (iRet == 0 && newParser.getSqlstatements().size() > 0) {
                this.getBodyStatements().add(newParser.getSqlstatements().get(0));
            } else {
                for (int j = 0; j < newParser.getErrorCount(); ++j) {
                    this.parseerrormessagehandle(newParser.getSyntaxErrors().get(j));
                }
            }
        }
    }

    private void snowflakeFunctionDefinition(TCustomSqlStatement psql, TCreateFunctionSqlNode createFunctionNode) {
        if (createFunctionNode.getFunctionBody() != null && this.getProcedureLanguage() == null) {
            String bodyStr = createFunctionNode.getFunctionBody().getStartToken().getQuotedString().trim();
            if (createFunctionNode.getFunctionBody().getStartToken().toString().startsWith("'")) {
                bodyStr = bodyStr.replaceAll("''", "'");
            }
            int testLen = 9;
            if (bodyStr.length() < testLen) {
                testLen = bodyStr.length();
            }
            String prefixStr = bodyStr.substring(0, testLen).toLowerCase();
            boolean isExpression = true;
            TGSqlParser newParser = new TGSqlParser(this.dbvendor);
            if (prefixStr.startsWith("select") || prefixStr.startsWith("insert") || prefixStr.startsWith("delete") || prefixStr.startsWith("update")) {
                newParser.sqltext = "\n" + TBaseType.stringBlock((int)createFunctionNode.getFunctionBody().getStartToken().lineNo, (int)createFunctionNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
                isExpression = false;
            } else {
                newParser.sqltext = "pseudo_expr_sign " + TBaseType.stringBlock((int)createFunctionNode.getFunctionBody().getStartToken().lineNo, (int)createFunctionNode.getFunctionBody().getStartToken().columnNo) + bodyStr;
            }
            newParser.setFrameStack(this.getFrameStack());
            int iRet = newParser.parse();
            if (iRet == 0 && newParser.getSqlstatements().size() > 0) {
                this.getBodyStatements().add(newParser.getSqlstatements().get(0));
            } else {
                for (int j = 0; j < newParser.getErrorCount(); ++j) {
                    this.parseerrormessagehandle(newParser.getSyntaxErrors().get(j));
                }
            }
        }
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        int i;
        if (this.rootNode == null) {
            return -1;
        }
        TCreateFunctionSqlNode createFunctionNode = (TCreateFunctionSqlNode)this.rootNode;
        super.doParseStatement(psql);
        TStackFrame currentStackFrame = new TStackFrame(this.stmtScope);
        currentStackFrame.pushStack(this.getFrameStack());
        this.functionName = createFunctionNode.getFunctionName();
        if (this.getSqlEnv() != null) {
            this.getSqlEnv().addFunction(this.functionName.toString(), true);
        }
        this.procedureLanguage = createFunctionNode.getProcedureLanguage();
        if (this.procedureLanguage != null) {
            this.setRoutineBodyInConstant(this.procedureLanguage);
            this.setRoutineLanguage(this.procedureLanguage.toString());
        }
        this.setParameterDeclarations(createFunctionNode.getParameters());
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().push(new TSymbolTableItem(9, (TCustomSqlStatement)this, (TParseTreeNode)this.getParameterDeclarations().getParameterDeclarationItem(i)));
                TParameterDeclaration parameterDeclaration = this.getParameterDeclarations().getParameterDeclarationItem(i);
                if (parameterDeclaration.getParameterName() == null) continue;
                this.stmtScope.addSymbol(new TSymbolVariable(parameterDeclaration.getParameterName(), parameterDeclaration, this.functionName));
            }
        }
        this.setReturnDataType(createFunctionNode.getReturnDataType());
        switch (this.dbvendor) {
            case dbvsnowflake: {
                this.snowflakeFunctionDefinition(psql, createFunctionNode);
                break;
            }
            case dbvredshift: {
                this.redshiftFunctionDefinition(psql, createFunctionNode);
                break;
            }
        }
        if (createFunctionNode.getStmt() != null) {
            createFunctionNode.getStmt().doParse(this, ESqlClause.unknown);
            this.getBodyStatements().add(createFunctionNode.getStmt().getStmt());
        } else if (createFunctionNode.getBlcok() != null) {
            createFunctionNode.getBlcok().getStmts().doParse(this, ESqlClause.unknown);
            for (i = 0; i < createFunctionNode.getBlcok().getStmts().size(); ++i) {
                this.getBodyStatements().add(createFunctionNode.getBlcok().getStmts().getStatementSqlNode(i).getStmt());
            }
        }
        if (this.getParameterDeclarations() != null) {
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                this.getTopStatement().getSymbolTable().pop();
            }
        }
        if (createFunctionNode.getSharedLibraryName() != null) {
            this.sharedLibraryName = createFunctionNode.getSharedLibraryName().toString();
        }
        this.functionDefinition = createFunctionNode.getFunctionDefinition();
        if (this.functionDefinition != null) {
            this.setRoutineBodyInConstant(this.functionDefinition);
            this.setRoutineBody(this.functionDefinition.toString());
        }
        this.endlabelName = createFunctionNode.getEndlabelName();
        currentStackFrame.popStack(this.getFrameStack());
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        if (this.getParameterDeclarations() != null) {
            this.getParameterDeclarations().acceptChildren(v);
        }
        this.getBodyStatements().acceptChildren(v);
        v.postVisit(this);
    }

    public void setFunctionName(TObjectName functionName) {
        this.functionName = functionName;
    }
}

