/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TCallSqlNode;
import gudusoft.gsqlparser.nodes.TExecParameterList;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TExpressionList;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;

public class TCallStatement
extends TCustomSqlStatement {
    private TObjectName routineName;
    private TObjectName hostVariable;
    private TObjectName indicatorVariable;
    private TExpressionList args;
    private TExpression routineExpr;
    private TExecParameterList parameterList;

    public TCallStatement(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstcall;
    }

    public TExecParameterList getParameterList() {
        return this.parameterList;
    }

    public TExpressionList getArgs() {
        return this.args;
    }

    public TObjectName getHostVariable() {
        return this.hostVariable;
    }

    public TObjectName getIndicatorVariable() {
        return this.indicatorVariable;
    }

    public TObjectName getRoutineName() {
        return this.routineName;
    }

    public TExpression getRoutineExpr() {
        return this.routineExpr;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TCallSqlNode callSqlNode = (TCallSqlNode)this.rootNode;
        this.routineExpr = callSqlNode.getRoutineExpr();
        this.args = callSqlNode.getArgs();
        this.routineName = callSqlNode.getRoutineName();
        this.indicatorVariable = callSqlNode.getIndicatorVariable();
        this.hostVariable = callSqlNode.getHostVariable();
        this.parameterList = callSqlNode.getParameterList();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setRoutineName(TObjectName routineName) {
        this.routineName = routineName;
    }

    public void setHostVariable(TObjectName hostVariable) {
        this.hostVariable = hostVariable;
    }

    public void setIndicatorVariable(TObjectName indicatorVariable) {
        this.indicatorVariable = indicatorVariable;
    }

    public void setArgs(TExpressionList args) {
        this.args = args;
    }

    public void setRoutineExpr(TExpression routineExpr) {
        this.routineExpr = routineExpr;
    }

    public void setParameterList(TExecParameterList parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }
}

