/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EAlterIndexOption;
import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.nodes.TAlterIndexSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.TPartitionExtensionClause;
import gudusoft.gsqlparser.nodes.hive.THiveKeyValueProperty;

public class TAlterIndexStmt
extends TCustomSqlStatement {
    private TObjectName onIndexName;
    private EAlterIndexOption alterIndexOption;
    private TPTNodeList<THiveKeyValueProperty> indexProperties;
    private TPartitionExtensionClause partitionSpec;
    private TObjectName indexName;
    private TObjectName tableName;

    public TObjectName getTableName() {
        return this.tableName;
    }

    public TObjectName getIndexName() {
        return this.indexName;
    }

    public TAlterIndexStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstalterindex;
    }

    public TObjectName getOnIndexName() {
        return this.onIndexName;
    }

    public EAlterIndexOption getAlterIndexOption() {
        return this.alterIndexOption;
    }

    public TPTNodeList<THiveKeyValueProperty> getIndexProperties() {
        return this.indexProperties;
    }

    public TPartitionExtensionClause getPartitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TAlterIndexSqlNode node = (TAlterIndexSqlNode)this.rootNode;
        this.indexName = node.getIndexName();
        this.onIndexName = node.getOnIndexName();
        this.tableName = node.getOnIndexName();
        if (this.tableName != null) {
            this.analyzeTablename(this.tableName);
        }
        this.partitionSpec = node.getPartitionSpec();
        this.indexProperties = node.getIndexProperties();
        this.alterIndexOption = node.getAlterIndexOption();
        return 0;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void setOnIndexName(TObjectName onIndexName) {
        this.onIndexName = onIndexName;
    }

    public void setAlterIndexOption(EAlterIndexOption alterIndexOption) {
        this.alterIndexOption = alterIndexOption;
    }

    public void setIndexProperties(TPTNodeList<THiveKeyValueProperty> indexProperties) {
        this.indexProperties = indexProperties;
    }

    public void setPartitionSpec(TPartitionExtensionClause partitionSpec) {
        this.partitionSpec = partitionSpec;
    }

    public void setIndexName(TObjectName indexName) {
        this.indexName = indexName;
    }

    @Override
    public void acceptChildren(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }
}

