/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.stmt;

import gudusoft.gsqlparser.EDbVendor;
import gudusoft.gsqlparser.ESqlStatementType;
import gudusoft.gsqlparser.TCustomSqlStatement;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TAlterDatabaseSqlNode;
import gudusoft.gsqlparser.nodes.TObjectName;
import gudusoft.gsqlparser.nodes.TPTNodeList;
import gudusoft.gsqlparser.nodes.TParseTreeVisitor;
import gudusoft.gsqlparser.nodes.hive.THiveKeyValueProperty;

public class TAlterDatabaseStmt
extends TCustomSqlStatement {
    private TObjectName databaseName;
    private TPTNodeList<THiveKeyValueProperty> dbProperties;
    private TObjectName newDatabaseName;
    private TObjectName ownerName;

    public TObjectName getNewDatabaseName() {
        return this.newDatabaseName;
    }

    public TObjectName getOwnerName() {
        return this.ownerName;
    }

    public TObjectName getDatabaseName() {
        return this.databaseName;
    }

    public TPTNodeList<THiveKeyValueProperty> getDbProperties() {
        return this.dbProperties;
    }

    public TAlterDatabaseStmt(EDbVendor dbvendor) {
        super(dbvendor);
        this.sqlstatementtype = ESqlStatementType.sstalterdatabase;
    }

    @Override
    public int doParseStatement(TCustomSqlStatement psql) {
        if (this.rootNode == null) {
            return -1;
        }
        super.doParseStatement(psql);
        TAlterDatabaseSqlNode node = (TAlterDatabaseSqlNode)this.rootNode;
        this.databaseName = node.getDatabaseName();
        this.dbProperties = node.getDbProperties();
        this.newDatabaseName = node.getNewDatabaseName();
        this.ownerName = node.getOwnerName();
        if (this.dbvendor == EDbVendor.dbvmssql) {
            TSourceToken st = null;
            boolean isNext = false;
            for (int i = 0; i < this.sourcetokenlist.size(); ++i) {
                st = this.sourcetokenlist.get(i);
                if (st.tokencode == 425) {
                    isNext = true;
                    continue;
                }
                if (!isNext || st.tokencode == 259) continue;
                this.databaseName = new TObjectName();
                this.databaseName.init(st);
                break;
            }
        }
        return 0;
    }

    public void setDatabaseName(TObjectName databaseName) {
        this.databaseName = databaseName;
    }

    public void setDbProperties(TPTNodeList<THiveKeyValueProperty> dbProperties) {
        this.dbProperties = dbProperties;
    }

    public void setNewDatabaseName(TObjectName newDatabaseName) {
        this.newDatabaseName = newDatabaseName;
    }

    public void setOwnerName(TObjectName ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public void accept(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }

    public void acceptChildern(TParseTreeVisitor v) {
        v.preVisit(this);
        v.postVisit(this);
    }
}

