/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.sqlenv;

import gudusoft.gsqlparser.sqlenv.ESQLDataObjectType;
import gudusoft.gsqlparser.sqlenv.TSQLCatalog;
import gudusoft.gsqlparser.sqlenv.TSQLFunction;
import gudusoft.gsqlparser.sqlenv.TSQLObject;
import gudusoft.gsqlparser.sqlenv.TSQLProcedure;
import gudusoft.gsqlparser.sqlenv.TSQLSchemaObject;
import gudusoft.gsqlparser.sqlenv.TSQLSynonyms;
import gudusoft.gsqlparser.sqlenv.TSQLTable;
import gudusoft.gsqlparser.sqlenv.TSQLTrigger;
import java.util.ArrayList;
import java.util.List;

public class TSQLSchema
extends TSQLObject {
    private TSQLCatalog catalog;
    private List<TSQLSchemaObject> schemaObjectList = new ArrayList<TSQLSchemaObject>();

    @Override
    public String getQualifiedName() {
        return this.catalog.name + "." + this.name;
    }

    public TSQLCatalog getCatalog() {
        return this.catalog;
    }

    public TSQLSchema(TSQLCatalog sqlCatalog, String schemaName) {
        super(sqlCatalog.getSqlEnv(), schemaName);
        this.dataObjectType = ESQLDataObjectType.dotSchema;
        this.catalog = sqlCatalog;
        this.catalog.addSchema(this);
    }

    public List<TSQLSchemaObject> getSchemaObjectList() {
        return this.schemaObjectList;
    }

    protected void addSchemaObject(TSQLSchemaObject schemaObject) {
        this.schemaObjectList.add(schemaObject);
        this.catalog.getSqlEnv().putSchemaObject(schemaObject.getQualifiedName(), schemaObject);
    }

    private TSQLSchemaObject findSchemaObject(String schemaObjectName) {
        for (TSQLSchemaObject t : this.schemaObjectList) {
            if (t.compareTo(schemaObjectName) != 0) continue;
            return t;
        }
        return null;
    }

    public TSQLProcedure createProcedure(String procedureName) {
        return (TSQLProcedure)this.createSchemaObject(procedureName, ESQLDataObjectType.dotProcedure);
    }

    public TSQLFunction createFunction(String functionName) {
        return (TSQLFunction)this.createSchemaObject(functionName, ESQLDataObjectType.dotFunction);
    }

    public TSQLTrigger createTrigger(String triggerName) {
        return (TSQLTrigger)this.createSchemaObject(triggerName, ESQLDataObjectType.dotTrigger);
    }

    public TSQLSynonyms createSynonyms(String synonymsName) {
        return (TSQLSynonyms)this.createSchemaObject(synonymsName, ESQLDataObjectType.dotSynonyms);
    }

    public TSQLTable createTable(String tableName) {
        return (TSQLTable)this.createSchemaObject(tableName, ESQLDataObjectType.dotTable);
    }

    protected TSQLSchemaObject createSchemaObject(String schemaObjectName, ESQLDataObjectType dataObjectType) {
        TSQLSchemaObject result = null;
        TSQLSchemaObject schemaObject = this.findSchemaObject(schemaObjectName);
        if (schemaObject == null) {
            switch (dataObjectType) {
                case dotTable: {
                    result = new TSQLTable(this, schemaObjectName);
                    break;
                }
                case dotProcedure: {
                    result = new TSQLProcedure(this, schemaObjectName);
                    break;
                }
                case dotFunction: {
                    result = new TSQLFunction(this, schemaObjectName);
                    break;
                }
                case dotTrigger: {
                    result = new TSQLTrigger(this, schemaObjectName);
                    break;
                }
                case dotSynonyms: {
                    result = new TSQLSynonyms(this, schemaObjectName);
                }
            }
        } else if (dataObjectType == schemaObject.getDataObjectType()) {
            result = schemaObject;
        }
        return result;
    }
}

