/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.sqlenv;

import gudusoft.gsqlparser.sqlenv.ESQLDataObjectType;
import gudusoft.gsqlparser.sqlenv.TSQLEnv;

public abstract class TSQLObject {
    protected String name = null;
    protected String nameKeepCase = null;
    protected TSQLEnv sqlEnv;
    protected ESQLDataObjectType dataObjectType = ESQLDataObjectType.dotUnknown;

    public TSQLEnv getSqlEnv() {
        return this.sqlEnv;
    }

    public TSQLObject(TSQLEnv sqlEnv, String objectName) {
        this.sqlEnv = sqlEnv;
        this.nameKeepCase = objectName;
        this.name = this.normalizeIdentifier(objectName);
    }

    public String getNameKeepCase() {
        return this.nameKeepCase;
    }

    public String getName() {
        return this.name;
    }

    public void setDataObjectType(ESQLDataObjectType dataObjectType) {
        this.dataObjectType = dataObjectType;
    }

    public ESQLDataObjectType getDataObjectType() {
        return this.dataObjectType;
    }

    public String getQualifiedName() {
        return "";
    }

    public boolean isDelimitedIdentifier(String identifier) {
        return TSQLObject.isDelimitedIdentifier(this.sqlEnv, identifier);
    }

    public String normalizeIdentifier(String identifier) {
        return TSQLObject.normalizeIdentifier(this.sqlEnv, this.dataObjectType, identifier);
    }

    public int compareTo(String objectName) {
        return TSQLObject.compareTo(this.sqlEnv, this.getDataObjectType(), this, objectName);
    }

    public static boolean isDelimitedIdentifier(TSQLEnv sqlEnv, String identifier) {
        boolean ret = false;
        switch (sqlEnv.getDBVendor()) {
            case dbvmssql: {
                ret = identifier.startsWith("[");
                break;
            }
            case dbvmysql: {
                ret = identifier.startsWith("`");
                break;
            }
            default: {
                ret = identifier.startsWith("\"");
            }
        }
        return ret;
    }

    public static String normalizeIdentifier(TSQLEnv sqlEnv, ESQLDataObjectType sqlDataObjectType, String identifier) {
        String ret;
        if (identifier == null) {
            return identifier;
        }
        if (identifier.length() == 0) {
            return identifier;
        }
        if (TSQLObject.isDelimitedIdentifier(sqlEnv, identifier)) {
            switch (sqlEnv.getDBVendor()) {
                case dbvmssql: {
                    ret = identifier.substring(1, identifier.length() - 1).toUpperCase();
                    break;
                }
                default: {
                    ret = identifier.substring(1, identifier.length() - 1);
                    break;
                }
            }
        } else {
            switch (sqlEnv.getDBVendor()) {
                case dbvmssql: {
                    ret = identifier.toUpperCase();
                    break;
                }
                case dbvmysql: {
                    ret = identifier;
                    break;
                }
                case dbvpostgresql: {
                    ret = identifier.toLowerCase();
                    break;
                }
                default: {
                    ret = identifier.toUpperCase();
                }
            }
        }
        return ret;
    }

    public static int compareTo(TSQLEnv sqlEnv, ESQLDataObjectType sqlDataObjectType, TSQLObject targetDataObject, String objectName) {
        int ret = 0;
        String normalizedName = TSQLObject.normalizeIdentifier(sqlEnv, sqlDataObjectType, objectName);
        switch (sqlEnv.getDBVendor()) {
            case dbvmssql: {
                ret = targetDataObject.getName().compareToIgnoreCase(normalizedName);
                break;
            }
            case dbvmysql: {
                if (sqlDataObjectType == ESQLDataObjectType.dotTable || sqlDataObjectType == ESQLDataObjectType.dotTrigger || sqlDataObjectType == ESQLDataObjectType.dotCatalog) {
                    ret = targetDataObject.getName().compareTo(normalizedName);
                    break;
                }
                ret = targetDataObject.getName().compareToIgnoreCase(normalizedName);
                break;
            }
            case dbvpostgresql: {
                ret = targetDataObject.getName().compareTo(normalizedName);
                break;
            }
            case dbvoracle: {
                ret = targetDataObject.getName().compareTo(normalizedName);
                break;
            }
            case dbvdb2: {
                ret = targetDataObject.getName().compareTo(normalizedName);
                break;
            }
            default: {
                ret = targetDataObject.getName().compareTo(normalizedName);
            }
        }
        return ret;
    }
}

